/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import com.aayushatharva.brotli4j.encoder.Encoder;
import io.netty5.handler.codec.compression.Brotli;
import io.netty5.handler.codec.compression.BrotliCompressor;
import io.netty5.handler.codec.compression.BrotliOptions;
import io.netty5.handler.codec.compression.CompressionOptions;
import io.netty5.handler.codec.compression.Compressor;
import io.netty5.handler.codec.compression.DeflateOptions;
import io.netty5.handler.codec.compression.GzipOptions;
import io.netty5.handler.codec.compression.StandardCompressionOptions;
import io.netty5.handler.codec.compression.ZlibCompressor;
import io.netty5.handler.codec.compression.ZlibWrapper;
import io.netty5.handler.codec.compression.Zstd;
import io.netty5.handler.codec.compression.ZstdCompressor;
import io.netty5.handler.codec.compression.ZstdOptions;
import io.netty5.handler.codec.http.HttpContent;
import io.netty5.handler.codec.http.HttpContentEncoder;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.util.internal.ObjectUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class HttpContentCompressor
extends HttpContentEncoder {
    private final boolean supportsCompressionOptions;
    private final BrotliOptions brotliOptions;
    private final GzipOptions gzipOptions;
    private final DeflateOptions deflateOptions;
    private final ZstdOptions zstdOptions;
    private final int compressionLevel;
    private final int contentSizeThreshold;
    private final Map<String, Supplier<? extends Compressor>> factories;

    public HttpContentCompressor() {
        this(6);
    }

    @Deprecated
    public HttpContentCompressor(int compressionLevel) {
        this(compressionLevel, 0);
    }

    @Deprecated
    public HttpContentCompressor(int compressionLevel, int contentSizeThreshold) {
        this.compressionLevel = ObjectUtil.checkInRange((int)compressionLevel, (int)0, (int)9, (String)"compressionLevel");
        this.contentSizeThreshold = ObjectUtil.checkPositiveOrZero((int)contentSizeThreshold, (String)"contentSizeThreshold");
        this.brotliOptions = null;
        this.gzipOptions = null;
        this.deflateOptions = null;
        this.zstdOptions = null;
        this.factories = null;
        this.supportsCompressionOptions = false;
    }

    public HttpContentCompressor(CompressionOptions ... compressionOptions) {
        this(0, compressionOptions);
    }

    public HttpContentCompressor(int contentSizeThreshold, CompressionOptions ... compressionOptions) {
        this.contentSizeThreshold = ObjectUtil.checkPositiveOrZero((int)contentSizeThreshold, (String)"contentSizeThreshold");
        BrotliOptions brotliOptions = null;
        GzipOptions gzipOptions = null;
        DeflateOptions deflateOptions = null;
        ZstdOptions zstdOptions = null;
        if (compressionOptions == null || compressionOptions.length == 0) {
            brotliOptions = Brotli.isAvailable() ? StandardCompressionOptions.brotli() : null;
            gzipOptions = StandardCompressionOptions.gzip();
            deflateOptions = StandardCompressionOptions.deflate();
            zstdOptions = Zstd.isAvailable() ? StandardCompressionOptions.zstd() : null;
        } else {
            ObjectUtil.deepCheckNotNull((String)"compressionOptions", (Object[])compressionOptions);
            for (CompressionOptions compressionOption : compressionOptions) {
                if (Brotli.isAvailable() && compressionOption instanceof BrotliOptions) {
                    brotliOptions = (BrotliOptions)compressionOption;
                    continue;
                }
                if (compressionOption instanceof GzipOptions) {
                    gzipOptions = (GzipOptions)compressionOption;
                    continue;
                }
                if (compressionOption instanceof DeflateOptions) {
                    deflateOptions = (DeflateOptions)compressionOption;
                    continue;
                }
                if (compressionOption instanceof ZstdOptions) {
                    zstdOptions = (ZstdOptions)compressionOption;
                    continue;
                }
                throw new IllegalArgumentException("Unsupported " + CompressionOptions.class.getSimpleName() + ": " + compressionOption);
            }
        }
        this.gzipOptions = gzipOptions;
        this.deflateOptions = deflateOptions;
        this.brotliOptions = brotliOptions;
        this.zstdOptions = zstdOptions;
        this.factories = new HashMap<String, Supplier<? extends Compressor>>();
        if (this.gzipOptions != null) {
            this.factories.put("gzip", ZlibCompressor.newFactory((ZlibWrapper)ZlibWrapper.GZIP, (int)gzipOptions.compressionLevel()));
        }
        if (this.deflateOptions != null) {
            this.factories.put("deflate", ZlibCompressor.newFactory((ZlibWrapper)ZlibWrapper.ZLIB, (int)deflateOptions.compressionLevel()));
        }
        if (Brotli.isAvailable() && this.brotliOptions != null) {
            this.factories.put("br", BrotliCompressor.newFactory((Encoder.Parameters)brotliOptions.parameters()));
        }
        if (this.zstdOptions != null) {
            this.factories.put("zstd", ZstdCompressor.newFactory((int)zstdOptions.compressionLevel(), (int)zstdOptions.blockSize(), (int)zstdOptions.maxEncodeSize()));
        }
        this.compressionLevel = -1;
        this.supportsCompressionOptions = true;
    }

    @Override
    protected HttpContentEncoder.Result beginEncode(HttpResponse httpResponse, String acceptEncoding) {
        String targetContentEncoding;
        if (this.contentSizeThreshold > 0 && httpResponse instanceof HttpContent && ((HttpContent)((Object)httpResponse)).payload().readableBytes() < this.contentSizeThreshold) {
            return null;
        }
        CharSequence contentEncoding = httpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        if (contentEncoding != null) {
            return null;
        }
        if (this.supportsCompressionOptions) {
            String targetContentEncoding2 = this.determineEncoding(acceptEncoding);
            if (targetContentEncoding2 == null) {
                return null;
            }
            Supplier<? extends Compressor> compressorFactory = this.factories.get(targetContentEncoding2);
            if (compressorFactory == null) {
                throw new Error();
            }
            return new HttpContentEncoder.Result(targetContentEncoding2, compressorFactory.get());
        }
        ZlibWrapper wrapper = this.determineWrapper(acceptEncoding);
        if (wrapper == null) {
            return null;
        }
        switch (wrapper) {
            case GZIP: {
                targetContentEncoding = "gzip";
                break;
            }
            case ZLIB: {
                targetContentEncoding = "deflate";
                break;
            }
            default: {
                throw new Error();
            }
        }
        return new HttpContentEncoder.Result(targetContentEncoding, (Compressor)ZlibCompressor.newFactory((ZlibWrapper)wrapper, (int)this.compressionLevel).get());
    }

    protected String determineEncoding(String acceptEncoding) {
        float starQ = -1.0f;
        float brQ = -1.0f;
        float zstdQ = -1.0f;
        float gzipQ = -1.0f;
        float deflateQ = -1.0f;
        for (String encoding : acceptEncoding.split(",")) {
            float q = 1.0f;
            int equalsPos = encoding.indexOf(61);
            if (equalsPos != -1) {
                try {
                    q = Float.parseFloat(encoding.substring(equalsPos + 1));
                }
                catch (NumberFormatException e) {
                    q = 0.0f;
                }
            }
            if (encoding.contains("*")) {
                starQ = q;
                continue;
            }
            if (encoding.contains("br") && q > brQ) {
                brQ = q;
                continue;
            }
            if (encoding.contains("zstd") && q > zstdQ) {
                zstdQ = q;
                continue;
            }
            if (encoding.contains("gzip") && q > gzipQ) {
                gzipQ = q;
                continue;
            }
            if (!encoding.contains("deflate") || !(q > deflateQ)) continue;
            deflateQ = q;
        }
        if (brQ > 0.0f || zstdQ > 0.0f || gzipQ > 0.0f || deflateQ > 0.0f) {
            if (brQ != -1.0f && brQ >= zstdQ && this.brotliOptions != null) {
                return "br";
            }
            if (zstdQ != -1.0f && zstdQ >= gzipQ && this.zstdOptions != null) {
                return "zstd";
            }
            if (gzipQ != -1.0f && gzipQ >= deflateQ && this.gzipOptions != null) {
                return "gzip";
            }
            if (deflateQ != -1.0f && this.deflateOptions != null) {
                return "deflate";
            }
        }
        if (starQ > 0.0f) {
            if (brQ == -1.0f && this.brotliOptions != null) {
                return "br";
            }
            if (zstdQ == -1.0f && this.zstdOptions != null) {
                return "zstd";
            }
            if (gzipQ == -1.0f && this.gzipOptions != null) {
                return "gzip";
            }
            if (deflateQ == -1.0f && this.deflateOptions != null) {
                return "deflate";
            }
        }
        return null;
    }

    @Deprecated
    protected ZlibWrapper determineWrapper(String acceptEncoding) {
        float starQ = -1.0f;
        float gzipQ = -1.0f;
        float deflateQ = -1.0f;
        for (String encoding : acceptEncoding.split(",")) {
            float q = 1.0f;
            int equalsPos = encoding.indexOf(61);
            if (equalsPos != -1) {
                try {
                    q = Float.parseFloat(encoding.substring(equalsPos + 1));
                }
                catch (NumberFormatException e) {
                    q = 0.0f;
                }
            }
            if (encoding.contains("*")) {
                starQ = q;
                continue;
            }
            if (encoding.contains("gzip") && q > gzipQ) {
                gzipQ = q;
                continue;
            }
            if (!encoding.contains("deflate") || !(q > deflateQ)) continue;
            deflateQ = q;
        }
        if (gzipQ > 0.0f || deflateQ > 0.0f) {
            if (gzipQ >= deflateQ) {
                return ZlibWrapper.GZIP;
            }
            return ZlibWrapper.ZLIB;
        }
        if (starQ > 0.0f) {
            if (gzipQ == -1.0f) {
                return ZlibWrapper.GZIP;
            }
            if (deflateQ == -1.0f) {
                return ZlibWrapper.ZLIB;
            }
        }
        return null;
    }
}

