/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.internal.DelegatingChannelHandlerContext;
import io.netty5.handler.codec.http.FullHttpResponse;
import io.netty5.handler.codec.http.HttpContent;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.netty5.handler.codec.http.HttpObject;
import io.netty5.handler.codec.http.HttpObjectAggregator;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.util.AsciiString;
import io.netty5.util.Send;
import io.netty5.util.concurrent.Future;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;

public class HttpClientUpgradeHandler<C extends HttpContent<C>>
extends HttpObjectAggregator<C> {
    private final SourceCodec sourceCodec;
    private final UpgradeCodec upgradeCodec;
    private boolean upgradeRequested;

    public HttpClientUpgradeHandler(SourceCodec sourceCodec, UpgradeCodec upgradeCodec, int maxContentLength) {
        super(maxContentLength);
        Objects.requireNonNull(sourceCodec, "sourceCodec");
        Objects.requireNonNull(upgradeCodec, "upgradeCodec");
        this.sourceCodec = sourceCodec;
        this.upgradeCodec = upgradeCodec;
    }

    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        if (!(msg instanceof HttpRequest)) {
            return ctx.write(msg);
        }
        if (this.upgradeRequested) {
            return ctx.newFailedFuture((Throwable)new IllegalStateException("Attempting to write HTTP request with upgrade in progress"));
        }
        this.upgradeRequested = true;
        this.setUpgradeRequestHeaders(ctx, (HttpRequest)msg);
        Future f = ctx.write(msg);
        ctx.fireChannelInboundEvent((Object)UpgradeEvent.UPGRADE_ISSUED);
        return f;
    }

    protected void decode(final ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        FullHttpResponse response = null;
        try {
            HttpResponse rep;
            if (!this.upgradeRequested) {
                throw new IllegalStateException("Read HTTP response without requesting protocol switch");
            }
            if (msg instanceof HttpResponse && !HttpResponseStatus.SWITCHING_PROTOCOLS.equals((rep = (HttpResponse)msg).status())) {
                ctx.fireChannelInboundEvent((Object)UpgradeEvent.UPGRADE_REJECTED);
                ctx.fireChannelRead((Object)msg);
                HttpClientUpgradeHandler.removeThisHandler(ctx);
                return;
            }
            if (msg instanceof FullHttpResponse) {
                response = (FullHttpResponse)msg;
                this.tryUpgrade(ctx, response);
            } else {
                super.decode((ChannelHandlerContext)new DelegatingChannelHandlerContext(ctx){

                    public ChannelHandlerContext fireChannelRead(Object msg) {
                        FullHttpResponse response = (FullHttpResponse)msg;
                        HttpClientUpgradeHandler.this.tryUpgrade(ctx, response);
                        return this;
                    }
                }, (Object)msg);
            }
        }
        catch (Throwable t) {
            if (response != null && response.isAccessible()) {
                response.close();
            }
            ctx.fireChannelExceptionCaught(t);
            HttpClientUpgradeHandler.removeThisHandler(ctx);
        }
    }

    private void tryUpgrade(ChannelHandlerContext ctx, FullHttpResponse response) {
        try (FullHttpResponse fullHttpResponse = response;){
            CharSequence upgradeHeader = response.headers().get((CharSequence)HttpHeaderNames.UPGRADE);
            if (upgradeHeader != null && !AsciiString.contentEqualsIgnoreCase((CharSequence)this.upgradeCodec.protocol(), (CharSequence)upgradeHeader)) {
                throw new IllegalStateException("Switching Protocols response with unexpected UPGRADE protocol: " + upgradeHeader);
            }
            this.sourceCodec.prepareUpgradeFrom(ctx);
            this.upgradeCodec.upgradeTo(ctx, (Send<FullHttpResponse>)response.send());
            ctx.fireChannelInboundEvent((Object)UpgradeEvent.UPGRADE_SUCCESSFUL);
            this.sourceCodec.upgradeFrom(ctx);
            HttpClientUpgradeHandler.removeThisHandler(ctx);
        }
        catch (Throwable t) {
            ctx.fireChannelExceptionCaught(t);
            HttpClientUpgradeHandler.removeThisHandler(ctx);
        }
    }

    private static void removeThisHandler(ChannelHandlerContext ctx) {
        ctx.pipeline().remove(ctx.name());
    }

    private void setUpgradeRequestHeaders(ChannelHandlerContext ctx, HttpRequest request) {
        request.headers().set((CharSequence)HttpHeaderNames.UPGRADE, this.upgradeCodec.protocol());
        LinkedHashSet<CharSequence> connectionParts = new LinkedHashSet<CharSequence>(2);
        connectionParts.addAll(this.upgradeCodec.setUpgradeHeaders(ctx, request));
        StringBuilder builder = new StringBuilder();
        for (CharSequence part : connectionParts) {
            builder.append(part);
            builder.append(',');
        }
        builder.append((CharSequence)HttpHeaderValues.UPGRADE);
        request.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)builder.toString());
    }

    public static interface UpgradeCodec {
        public CharSequence protocol();

        public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext var1, HttpRequest var2);

        public void upgradeTo(ChannelHandlerContext var1, Send<FullHttpResponse> var2) throws Exception;
    }

    public static interface SourceCodec {
        public void prepareUpgradeFrom(ChannelHandlerContext var1);

        public void upgradeFrom(ChannelHandlerContext var1);
    }

    public static enum UpgradeEvent {
        UPGRADE_ISSUED,
        UPGRADE_SUCCESSFUL,
        UPGRADE_REJECTED;

    }
}

