/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.unsafe;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.Drop;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.util.internal.PlatformDependent;

class FreeAddress
implements Runnable,
Drop<Buffer> {
    private final long address;
    private final int size;

    FreeAddress(long address, int size) {
        this.address = address;
        this.size = size;
    }

    @Override
    public void run() {
        PlatformDependent.freeMemory((long)this.address);
        InternalBufferUtils.MEM_USAGE_NATIVE.add(-this.size);
    }

    @Override
    public void drop(Buffer obj) {
        this.run();
    }

    @Override
    public Drop<Buffer> fork() {
        throw new IllegalStateException(this + " cannot fork. Must be guarded by an ArcDrop.");
    }

    @Override
    public void attach(Buffer obj) {
    }

    public String toString() {
        return String.format("FreeAddress(0x%x, %s bytes)", this.address, this.size);
    }
}

