/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.pool;

import io.netty5.buffer.AllocationType;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.Drop;
import io.netty5.buffer.MemoryManager;
import io.netty5.buffer.internal.DropCaptor;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.buffer.pool.PooledBufferAllocator;
import io.netty5.buffer.pool.UntetheredMemory;

class UnpooledUntetheredMemory
implements UntetheredMemory {
    private final MemoryManager manager;
    private final Buffer buffer;
    private final DropCaptor<Buffer> dropCaptor;

    UnpooledUntetheredMemory(PooledBufferAllocator allocator, MemoryManager manager, AllocationType allocationType, int size) {
        this.manager = manager;
        this.dropCaptor = new DropCaptor();
        this.buffer = manager.allocateShared(allocator.getPooledAllocatorControl(), size, this.dropCaptor, allocationType);
    }

    @Override
    public <Memory> Memory memory() {
        return (Memory)this.manager.unwrapRecoverableMemory(this.buffer);
    }

    @Override
    public <BufferType extends Buffer> Drop<BufferType> drop() {
        return InternalBufferUtils.standardDrop(this.manager).apply(this.dropCaptor.getDrop());
    }
}

