/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.pool;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.Drop;
import io.netty5.buffer.pool.PoolChunk;
import io.netty5.buffer.pool.PoolThreadCache;

class PooledDrop
implements Drop<Buffer> {
    private final Drop<Buffer> baseDrop;
    private final PoolChunk chunk;
    private final PoolThreadCache threadCache;
    private final long handle;
    private final int normSize;

    PooledDrop(PoolChunk chunk, PoolThreadCache threadCache, long handle, int normSize) {
        this.baseDrop = chunk.baseDrop.fork();
        this.chunk = chunk;
        this.threadCache = threadCache;
        this.handle = handle;
        this.normSize = normSize;
    }

    @Override
    public void drop(Buffer obj) {
        this.chunk.arena.free(this.chunk, this.handle, this.normSize, this.threadCache);
        this.baseDrop.drop(this.chunk.base);
    }

    @Override
    public Drop<Buffer> fork() {
        return new PooledDrop(this.chunk, this.threadCache, this.handle, this.normSize);
    }

    @Override
    public void attach(Buffer obj) {
    }
}

