/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.pool;

import io.netty5.buffer.pool.PoolArena;
import io.netty5.buffer.pool.PoolChunk;
import io.netty5.buffer.pool.PoolChunkListMetric;
import io.netty5.buffer.pool.PoolChunkMetric;
import io.netty5.buffer.pool.PoolThreadCache;
import io.netty5.buffer.pool.UntetheredMemory;
import io.netty5.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

final class PoolChunkList
implements PoolChunkListMetric {
    private static final Iterator<PoolChunkMetric> EMPTY_METRICS = Collections.emptyIterator();
    private final PoolArena arena;
    private final PoolChunkList nextList;
    private final int minUsage;
    private final int maxUsage;
    private final int maxCapacity;
    private PoolChunk head;
    private final int freeMinThreshold;
    private final int freeMaxThreshold;
    private PoolChunkList prevList;

    PoolChunkList(PoolArena arena, PoolChunkList nextList, int minUsage, int maxUsage, int chunkSize) {
        assert (minUsage <= maxUsage);
        this.arena = arena;
        this.nextList = nextList;
        this.minUsage = minUsage;
        this.maxUsage = maxUsage;
        this.maxCapacity = PoolChunkList.calculateMaxCapacity(minUsage, chunkSize);
        this.freeMinThreshold = maxUsage == 100 ? 0 : (int)((double)chunkSize * (100.0 - (double)maxUsage + 0.99999999) / 100.0);
        this.freeMaxThreshold = minUsage == 100 ? 0 : (int)((double)chunkSize * (100.0 - (double)minUsage + 0.99999999) / 100.0);
    }

    private static int calculateMaxCapacity(int minUsage, int chunkSize) {
        if ((minUsage = PoolChunkList.minUsage0(minUsage)) == 100) {
            return 0;
        }
        return (int)((long)chunkSize * (100L - (long)minUsage) / 100L);
    }

    void prevList(PoolChunkList prevList) {
        assert (this.prevList == null);
        this.prevList = prevList;
    }

    UntetheredMemory allocate(int size, int sizeIdx, PoolThreadCache threadCache) {
        int normCapacity = this.arena.sizeIdx2size(sizeIdx);
        if (normCapacity > this.maxCapacity) {
            return null;
        }
        PoolChunk cur = this.head;
        while (cur != null) {
            UntetheredMemory memory = cur.allocate(size, sizeIdx, threadCache);
            if (memory != null) {
                if (cur.freeBytes <= this.freeMinThreshold) {
                    this.remove(cur);
                    this.nextList.add(cur);
                }
                return memory;
            }
            cur = cur.next;
        }
        return null;
    }

    boolean free(PoolChunk chunk, long handle, int normCapacity) {
        chunk.free(handle, normCapacity);
        if (chunk.freeBytes > this.freeMaxThreshold) {
            this.remove(chunk);
            return this.move0(chunk);
        }
        return true;
    }

    private boolean move(PoolChunk chunk) {
        if (chunk.freeBytes > this.freeMaxThreshold) {
            return this.move0(chunk);
        }
        this.add0(chunk);
        return true;
    }

    private boolean move0(PoolChunk chunk) {
        if (this.prevList == null) {
            return false;
        }
        return this.prevList.move(chunk);
    }

    void add(PoolChunk chunk) {
        if (chunk.freeBytes <= this.freeMinThreshold) {
            this.nextList.add(chunk);
            return;
        }
        this.add0(chunk);
    }

    void add0(PoolChunk chunk) {
        chunk.parent = this;
        if (this.head == null) {
            this.head = chunk;
            chunk.prev = null;
            chunk.next = null;
        } else {
            chunk.prev = null;
            chunk.next = this.head;
            this.head.prev = chunk;
            this.head = chunk;
        }
    }

    private void remove(PoolChunk cur) {
        if (cur == this.head) {
            this.head = cur.next;
            if (this.head != null) {
                this.head.prev = null;
            }
        } else {
            PoolChunk next;
            cur.prev.next = next = cur.next;
            if (next != null) {
                next.prev = cur.prev;
            }
        }
    }

    @Override
    public int minUsage() {
        return PoolChunkList.minUsage0(this.minUsage);
    }

    @Override
    public int maxUsage() {
        return Math.min(this.maxUsage, 100);
    }

    private static int minUsage0(int value) {
        return Math.max(1, value);
    }

    @Override
    public Iterator<PoolChunkMetric> iterator() {
        this.arena.lock();
        try {
            if (this.head == null) {
                Iterator<PoolChunkMetric> iterator = EMPTY_METRICS;
                return iterator;
            }
            ArrayList<PoolChunk> metrics = new ArrayList<PoolChunk>();
            PoolChunk cur = this.head;
            do {
                metrics.add(cur);
            } while ((cur = cur.next) != null);
            Iterator<PoolChunkMetric> iterator = metrics.iterator();
            return iterator;
        }
        finally {
            this.arena.unlock();
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.arena.lock();
        try {
            if (this.head == null) {
                String string = "none";
                return string;
            }
            PoolChunk cur = this.head;
            while (true) {
                buf.append(cur);
                cur = cur.next;
                if (cur == null) {
                    break;
                }
                buf.append(StringUtil.NEWLINE);
            }
        }
        finally {
            this.arena.unlock();
        }
        return buf.toString();
    }

    void destroy() {
        PoolChunk chunk = this.head;
        while (chunk != null) {
            chunk.destroy();
            PoolChunk tmp = chunk;
            chunk = chunk.next;
            tmp.next = null;
            tmp.prev = null;
        }
        this.head = null;
    }
}

