/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.pool;

import io.netty5.buffer.AllocationType;
import io.netty5.buffer.MemoryManager;
import io.netty5.buffer.pool.PoolArenaMetric;
import io.netty5.buffer.pool.PoolChunk;
import io.netty5.buffer.pool.PoolChunkList;
import io.netty5.buffer.pool.PoolChunkListMetric;
import io.netty5.buffer.pool.PoolChunkMetric;
import io.netty5.buffer.pool.PoolSubpage;
import io.netty5.buffer.pool.PoolSubpageMetric;
import io.netty5.buffer.pool.PoolThreadCache;
import io.netty5.buffer.pool.PooledBufferAllocator;
import io.netty5.buffer.pool.SizeClasses;
import io.netty5.buffer.pool.UnpooledUntetheredMemory;
import io.netty5.buffer.pool.UntetheredMemory;
import io.netty5.util.internal.StringUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;

class PoolArena
extends SizeClasses
implements PoolArenaMetric {
    private static final VarHandle SUBPAGE_ARRAY = MethodHandles.arrayElementVarHandle(PoolSubpage[].class);
    final PooledBufferAllocator parent;
    final MemoryManager manager;
    final AllocationType allocationType;
    final int numSmallSubpagePools;
    final int directMemoryCacheAlignment;
    private final PoolSubpage[] smallSubpagePools;
    private final PoolChunkList q050;
    private final PoolChunkList q025;
    private final PoolChunkList q000;
    private final PoolChunkList qInit;
    private final PoolChunkList q075;
    private final PoolChunkList q100;
    private final List<PoolChunkListMetric> chunkListMetrics;
    private long allocationsNormal;
    private final LongAdder allocationsSmall = new LongAdder();
    private final LongAdder allocationsHuge = new LongAdder();
    private final LongAdder activeBytesHuge = new LongAdder();
    private long deallocationsSmall;
    private long deallocationsNormal;
    private final LongAdder deallocationsHuge = new LongAdder();
    final AtomicInteger numThreadCaches = new AtomicInteger();
    private final ReentrantLock lock = new ReentrantLock();

    protected PoolArena(PooledBufferAllocator parent, MemoryManager manager, AllocationType allocationType, int pageSize, int pageShifts, int chunkSize, int cacheAlignment) {
        super(pageSize, pageShifts, chunkSize, cacheAlignment);
        this.parent = parent;
        this.manager = manager;
        this.allocationType = allocationType;
        this.directMemoryCacheAlignment = cacheAlignment;
        this.numSmallSubpagePools = this.nSubpages;
        this.smallSubpagePools = PoolArena.newSubpagePoolArray(this.numSmallSubpagePools);
        this.q100 = new PoolChunkList(this, null, 100, Integer.MAX_VALUE, chunkSize);
        this.q075 = new PoolChunkList(this, this.q100, 75, 100, chunkSize);
        this.q050 = new PoolChunkList(this, this.q075, 50, 100, chunkSize);
        this.q025 = new PoolChunkList(this, this.q050, 25, 75, chunkSize);
        this.q000 = new PoolChunkList(this, this.q025, 1, 50, chunkSize);
        this.qInit = new PoolChunkList(this, this.q000, Integer.MIN_VALUE, 25, chunkSize);
        this.q100.prevList(this.q075);
        this.q075.prevList(this.q050);
        this.q050.prevList(this.q025);
        this.q025.prevList(this.q000);
        this.q000.prevList(null);
        this.qInit.prevList(this.qInit);
        this.chunkListMetrics = List.of(this.qInit, this.q000, this.q025, this.q050, this.q075, this.q100);
    }

    private static PoolSubpage newSubpagePoolHead() {
        PoolSubpage head;
        head.prev = head = new PoolSubpage();
        head.next = head;
        return head;
    }

    private static PoolSubpage[] newSubpagePoolArray(int size) {
        return new PoolSubpage[size];
    }

    UntetheredMemory allocate(PoolThreadCache cache, int size) {
        int sizeIdx = this.size2SizeIdx(size);
        if (sizeIdx <= this.smallMaxSizeIdx) {
            return this.tcacheAllocateSmall(cache, size, sizeIdx);
        }
        if (sizeIdx < this.nSizes) {
            return this.tcacheAllocateNormal(cache, size, sizeIdx);
        }
        int normCapacity = this.directMemoryCacheAlignment > 0 ? this.normalizeSize(size) : size;
        return this.allocateHuge(normCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UntetheredMemory tcacheAllocateSmall(PoolThreadCache cache, int size, int sizeIdx) {
        boolean needsNormalAllocation;
        UntetheredMemory memory = cache.allocateSmall(size, sizeIdx);
        if (memory != null) {
            return memory;
        }
        PoolSubpage head = this.findSubpagePoolHead(sizeIdx);
        head.lock();
        try {
            PoolSubpage s = head.next;
            boolean bl = needsNormalAllocation = s == head;
            if (!needsNormalAllocation) {
                assert (s.doNotDestroy && s.elemSize == this.sizeIdx2size(sizeIdx)) : "doNotDestroy=" + s.doNotDestroy + ", elemSize=" + s.elemSize + ", sizeIdx=" + sizeIdx;
                long handle = s.allocate();
                assert (handle >= 0L);
                memory = s.chunk.allocateBufferWithSubpage(handle, size, cache);
            }
        }
        finally {
            head.unlock();
        }
        if (needsNormalAllocation) {
            this.lock();
            try {
                memory = this.allocateNormal(size, sizeIdx, cache);
            }
            finally {
                this.unlock();
            }
        }
        this.incSmallAllocation();
        return memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UntetheredMemory tcacheAllocateNormal(PoolThreadCache cache, int size, int sizeIdx) {
        UntetheredMemory memory = cache.allocateNormal(this, size, sizeIdx);
        if (memory != null) {
            return memory;
        }
        this.lock();
        try {
            memory = this.allocateNormal(size, sizeIdx, cache);
            ++this.allocationsNormal;
        }
        finally {
            this.unlock();
        }
        return memory;
    }

    private UntetheredMemory allocateNormal(int size, int sizeIdx, PoolThreadCache threadCache) {
        assert (this.lock.isHeldByCurrentThread());
        UntetheredMemory memory = this.q050.allocate(size, sizeIdx, threadCache);
        if (memory != null) {
            return memory;
        }
        memory = this.q025.allocate(size, sizeIdx, threadCache);
        if (memory != null) {
            return memory;
        }
        memory = this.q000.allocate(size, sizeIdx, threadCache);
        if (memory != null) {
            return memory;
        }
        memory = this.qInit.allocate(size, sizeIdx, threadCache);
        if (memory != null) {
            return memory;
        }
        memory = this.q075.allocate(size, sizeIdx, threadCache);
        if (memory != null) {
            return memory;
        }
        PoolChunk c = this.newChunk(this.pageSize, this.nPSizes, this.pageShifts, this.chunkSize);
        memory = c.allocate(size, sizeIdx, threadCache);
        assert (memory != null);
        this.qInit.add(c);
        return memory;
    }

    private void incSmallAllocation() {
        this.allocationsSmall.increment();
    }

    private UntetheredMemory allocateHuge(int size) {
        this.activeBytesHuge.add(size);
        this.allocationsHuge.increment();
        return new UnpooledUntetheredMemory(this.parent, this.manager, this.allocationType, size);
    }

    void free(PoolChunk chunk, long handle, int normCapacity, PoolThreadCache cache) {
        SizeClass sizeClass = PoolArena.sizeClass(handle);
        if (cache != null && cache.add(this, chunk, handle, normCapacity, sizeClass)) {
            return;
        }
        this.freeChunk(chunk, handle, normCapacity, sizeClass);
    }

    private static SizeClass sizeClass(long handle) {
        return PoolChunk.isSubpage(handle) ? SizeClass.Small : SizeClass.Normal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeChunk(PoolChunk chunk, long handle, int normCapacity, SizeClass sizeClass) {
        boolean destroyChunk;
        this.lock();
        try {
            if (sizeClass == SizeClass.Normal) {
                ++this.deallocationsNormal;
            } else if (sizeClass == SizeClass.Small) {
                ++this.deallocationsSmall;
            } else {
                throw new AssertionError((Object)("Unexpected size class: " + sizeClass));
            }
            destroyChunk = !chunk.parent.free(chunk, handle, normCapacity);
        }
        finally {
            this.unlock();
        }
        if (destroyChunk) {
            chunk.destroy();
        }
    }

    PoolSubpage findSubpagePoolHead(int sizeIdx) {
        PoolSubpage head = SUBPAGE_ARRAY.getVolatile(this.smallSubpagePools, sizeIdx);
        if (head == null && !SUBPAGE_ARRAY.compareAndSet(this.smallSubpagePools, sizeIdx, null, head = PoolArena.newSubpagePoolHead())) {
            head = SUBPAGE_ARRAY.getVolatile(this.smallSubpagePools, sizeIdx);
        }
        return head;
    }

    @Override
    public int numThreadCaches() {
        return this.numThreadCaches.get();
    }

    @Override
    public int numSmallSubpages() {
        return this.smallSubpagePools.length;
    }

    @Override
    public int numChunkLists() {
        return this.chunkListMetrics.size();
    }

    @Override
    public List<PoolSubpageMetric> smallSubpages() {
        return PoolArena.subPageMetricList(this.smallSubpagePools);
    }

    @Override
    public List<PoolChunkListMetric> chunkLists() {
        return this.chunkListMetrics;
    }

    private static List<PoolSubpageMetric> subPageMetricList(PoolSubpage[] pages) {
        ArrayList<PoolSubpageMetric> metrics = new ArrayList<PoolSubpageMetric>();
        int len = pages.length;
        for (int i = 0; i < len; ++i) {
            PoolSubpage head = SUBPAGE_ARRAY.getVolatile(pages, i);
            if (head == null || head.next == head) continue;
            PoolSubpage s = head.next;
            do {
                metrics.add(s);
            } while ((s = s.next) != head);
        }
        return metrics;
    }

    @Override
    public long numAllocations() {
        long allocsNormal;
        this.lock();
        try {
            allocsNormal = this.allocationsNormal;
        }
        finally {
            this.unlock();
        }
        return this.allocationsSmall.longValue() + allocsNormal + this.allocationsHuge.longValue();
    }

    @Override
    public long numSmallAllocations() {
        return this.allocationsSmall.longValue();
    }

    @Override
    public long numNormalAllocations() {
        this.lock();
        try {
            long l = this.allocationsNormal;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long numDeallocations() {
        long deallocs;
        this.lock();
        try {
            deallocs = this.deallocationsSmall + this.deallocationsNormal;
        }
        finally {
            this.unlock();
        }
        return deallocs + this.deallocationsHuge.longValue();
    }

    @Override
    public long numSmallDeallocations() {
        this.lock();
        try {
            long l = this.deallocationsSmall;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long numNormalDeallocations() {
        this.lock();
        try {
            long l = this.deallocationsNormal;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long numHugeAllocations() {
        return this.allocationsHuge.longValue();
    }

    @Override
    public long numHugeDeallocations() {
        return this.deallocationsHuge.longValue();
    }

    @Override
    public long numActiveAllocations() {
        long val = this.allocationsSmall.longValue() + this.allocationsHuge.longValue() - this.deallocationsHuge.longValue();
        this.lock();
        try {
        }
        finally {
            this.unlock();
        }
        return Math.max(val += this.allocationsNormal - (this.deallocationsSmall + this.deallocationsNormal), 0L);
    }

    @Override
    public long numActiveSmallAllocations() {
        return Math.max(this.numSmallAllocations() - this.numSmallDeallocations(), 0L);
    }

    @Override
    public long numActiveNormalAllocations() {
        long val;
        this.lock();
        try {
            val = this.allocationsNormal - this.deallocationsNormal;
        }
        finally {
            this.unlock();
        }
        return Math.max(val, 0L);
    }

    @Override
    public long numActiveHugeAllocations() {
        return Math.max(this.numHugeAllocations() - this.numHugeDeallocations(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numActiveBytes() {
        long val = this.activeBytesHuge.longValue();
        this.lock();
        try {
            for (int i = 0; i < this.chunkListMetrics.size(); ++i) {
                for (PoolChunkMetric m : this.chunkListMetrics.get(i)) {
                    val += (long)m.chunkSize();
                }
            }
        }
        finally {
            this.unlock();
        }
        return Math.max(0L, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numPinnedBytes() {
        long val = this.activeBytesHuge.longValue();
        this.lock();
        try {
            for (int i = 0; i < this.chunkListMetrics.size(); ++i) {
                for (PoolChunkMetric m : this.chunkListMetrics.get(i)) {
                    val += (long)m.pinnedBytes();
                }
            }
        }
        finally {
            this.unlock();
        }
        return Math.max(0L, val);
    }

    protected final PoolChunk newChunk(int pageSize, int maxPageIdx, int pageShifts, int chunkSize) {
        return new PoolChunk(this, pageSize, pageShifts, chunkSize, maxPageIdx);
    }

    public String toString() {
        this.lock();
        try {
            StringBuilder buf = new StringBuilder().append("Chunk(s) at 0~25%:").append(StringUtil.NEWLINE).append(this.qInit).append(StringUtil.NEWLINE).append("Chunk(s) at 0~50%:").append(StringUtil.NEWLINE).append(this.q000).append(StringUtil.NEWLINE).append("Chunk(s) at 25~75%:").append(StringUtil.NEWLINE).append(this.q025).append(StringUtil.NEWLINE).append("Chunk(s) at 50~100%:").append(StringUtil.NEWLINE).append(this.q050).append(StringUtil.NEWLINE).append("Chunk(s) at 75~100%:").append(StringUtil.NEWLINE).append(this.q075).append(StringUtil.NEWLINE).append("Chunk(s) at 100%:").append(StringUtil.NEWLINE).append(this.q100).append(StringUtil.NEWLINE).append("small subpages:");
            PoolArena.appendPoolSubPages(buf, this.smallSubpagePools);
            buf.append(StringUtil.NEWLINE);
            String string = buf.toString();
            return string;
        }
        finally {
            this.unlock();
        }
    }

    private static void appendPoolSubPages(StringBuilder buf, PoolSubpage[] subpages) {
        for (int i = 0; i < subpages.length; ++i) {
            PoolSubpage head = SUBPAGE_ARRAY.getVolatile(subpages, i);
            if (head == null || head.next == head) continue;
            buf.append(StringUtil.NEWLINE).append(i).append(": ");
            PoolSubpage s = head.next;
            do {
                buf.append(s);
            } while ((s = s.next) != head);
        }
    }

    public void close() {
        int len = this.smallSubpagePools.length;
        for (int i = 0; i < len; ++i) {
            PoolSubpage page = SUBPAGE_ARRAY.getVolatile(this.smallSubpagePools, i);
            if (page == null) continue;
            page.destroy();
            SUBPAGE_ARRAY.setVolatile(this.smallSubpagePools, i, null);
        }
        for (PoolChunkList list : new PoolChunkList[]{this.qInit, this.q000, this.q025, this.q050, this.q100}) {
            list.destroy();
        }
    }

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    static enum SizeClass {
        Small,
        Normal;

    }
}

