/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.internal;

import io.netty5.buffer.Drop;
import io.netty5.buffer.Owned;
import io.netty5.buffer.internal.LifecycleTracer;
import io.netty5.buffer.internal.SendFromOwned;
import io.netty5.util.Resource;
import io.netty5.util.Send;
import io.netty5.util.internal.UnstableApi;
import java.lang.ref.Reference;
import java.util.Objects;

@UnstableApi
public abstract class ResourceSupport<I extends Resource<I>, T extends ResourceSupport<I, T>>
implements Resource<I> {
    private int acquires;
    private Drop<T> drop;
    private final LifecycleTracer tracer;

    protected ResourceSupport(Drop<T> drop) {
        this.drop = drop;
        this.tracer = LifecycleTracer.get();
        this.tracer.allocate();
    }

    static <T> T acquire(ResourceSupport<?, ?> obj) {
        return (T)obj.acquire();
    }

    static LifecycleTracer getTracer(ResourceSupport<?, ?> obj) {
        return obj.tracer;
    }

    protected final T acquire() {
        if (this.acquires < 0) {
            throw this.attachTrace(this.createResourceClosedException());
        }
        if (this.acquires == Integer.MAX_VALUE) {
            throw new IllegalStateException("Reached maximum allowed acquires (2147483647).");
        }
        ++this.acquires;
        this.tracer.acquire(this.acquires);
        return this.impl();
    }

    protected abstract RuntimeException createResourceClosedException();

    public final void close() {
        int acq;
        if (this.acquires == -1) {
            throw this.attachTrace(new IllegalStateException("Double-free: Resource already closed and dropped."));
        }
        if ((acq = this.acquires--) != 0) {
            this.tracer.close(acq);
        } else {
            this.tracer.drop(0);
            try {
                this.drop.drop(this.impl());
                Reference.reachabilityFence(this);
            }
            finally {
                this.makeInaccessible();
            }
        }
    }

    public final Send<I> send() {
        if (this.acquires < 0) {
            throw this.attachTrace(this.createResourceClosedException());
        }
        if (!this.isOwned()) {
            throw this.notSendableException();
        }
        try {
            Owned<T> owned = this.tracer.send(this.prepareSend());
            SendFromOwned sendFromOwned = new SendFromOwned(owned, this.drop, this.getClass());
            return sendFromOwned;
        }
        finally {
            this.acquires = -2;
            this.makeInaccessible();
        }
    }

    protected <E extends Throwable> E attachTrace(E throwable) {
        return this.tracer.attachTrace(throwable);
    }

    protected IllegalStateException notSendableException() {
        return new IllegalStateException("Cannot send() a reference counted object with " + this.countBorrows() + " borrows: " + this + ".");
    }

    static boolean isOwned(ResourceSupport<?, ?> obj) {
        return obj.isOwned();
    }

    protected boolean isOwned() {
        return this.acquires == 0;
    }

    static int countBorrows(ResourceSupport<?, ?> obj) {
        return obj.countBorrows();
    }

    protected int countBorrows() {
        return Math.max(this.acquires, 0);
    }

    public boolean isAccessible() {
        return this.acquires >= 0;
    }

    public I touch(Object hint) {
        if (this.isAccessible()) {
            this.tracer.touch(hint);
        }
        return this.self();
    }

    protected abstract Owned<T> prepareSend();

    protected void makeInaccessible() {
    }

    protected Drop<T> unsafeGetDrop() {
        return this.drop;
    }

    protected void unsafeSetDrop(Drop<T> replacement) {
        this.drop = Objects.requireNonNull(replacement, "Replacement drop cannot be null.");
    }

    private I self() {
        return (I)this;
    }

    private T impl() {
        return (T)this;
    }
}

