/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.internal;

import io.netty5.buffer.MemoryManager;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MemoryManagerLoader {
    private static final AtomicReference<List<ServiceLoader.Provider<MemoryManager>>> CACHE = new AtomicReference();
    private static final ReentrantLock CACHE_POP_LOCK = new ReentrantLock();

    private MemoryManagerLoader() {
    }

    public static Stream<ServiceLoader.Provider<MemoryManager>> stream() {
        List<ServiceLoader.Provider<MemoryManager>> cachedList = CACHE.get();
        if (cachedList != null) {
            return cachedList.stream();
        }
        CACHE_POP_LOCK.lock();
        try {
            cachedList = CACHE.get();
            if (cachedList != null) {
                Stream<ServiceLoader.Provider<MemoryManager>> stream = cachedList.stream();
                return stream;
            }
            ServiceLoader<MemoryManager> loader = ServiceLoader.load(MemoryManager.class);
            cachedList = List.copyOf(loader.stream().collect(Collectors.toList()));
            CACHE.set(cachedList);
            Stream<ServiceLoader.Provider<MemoryManager>> stream = cachedList.stream();
            return stream;
        }
        finally {
            CACHE_POP_LOCK.unlock();
        }
    }
}

