/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.internal;

import io.netty5.buffer.Drop;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public final class ArcDrop<T>
implements Drop<T> {
    private static final VarHandle COUNT;
    private final Drop<T> delegate;
    private volatile int count;

    public ArcDrop(Drop<T> delegate) {
        this.delegate = delegate;
    }

    public static <X> Drop<X> wrap(Drop<X> drop) {
        if (drop.getClass() == ArcDrop.class) {
            return drop;
        }
        return new ArcDrop<X>(drop);
    }

    public static <X> Drop<X> acquire(Drop<X> drop) {
        if (drop.getClass() == ArcDrop.class) {
            ((ArcDrop)drop).increment();
            return drop;
        }
        return new ArcDrop<X>(drop);
    }

    public ArcDrop<T> increment() {
        int c;
        do {
            c = this.count;
            ArcDrop.checkValidState(c);
        } while (!COUNT.compareAndSet(this, c, c + 1));
        return this;
    }

    @Override
    public void drop(T obj) {
        int n;
        int c;
        do {
            c = this.count;
            n = c - 1;
            ArcDrop.checkValidState(c);
        } while (!COUNT.compareAndSet(this, c, n));
        if (n == -1) {
            this.delegate.drop(obj);
        }
    }

    @Override
    public Drop<T> fork() {
        return this.increment();
    }

    @Override
    public void attach(T obj) {
        this.delegate.attach(obj);
    }

    public Drop<T> unwrap() {
        return this.delegate;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("ArcDrop@").append(Integer.toHexString(System.identityHashCode(this))).append('(').append(this.count).append(", ");
        Drop<T> drop = this;
        while ((drop = drop.unwrap()) instanceof ArcDrop) {
            builder.append(drop.count).append(", ");
        }
        return builder.append(drop).append(')').toString();
    }

    private static void checkValidState(int count) {
        if (count == -1) {
            throw new IllegalStateException("Underlying resources have already been freed.");
        }
    }

    static {
        try {
            COUNT = MethodHandles.lookup().findVarHandle(ArcDrop.class, "count", Integer.TYPE);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

