/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAccessor;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.BufferReadOnlyException;
import io.netty5.buffer.ByteCursor;
import io.netty5.buffer.ComponentIterator;
import io.netty5.buffer.CompositeBuffer;
import io.netty5.buffer.Drop;
import io.netty5.buffer.Owned;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.buffer.internal.ResourceSupport;
import io.netty5.util.SafeCloseable;
import io.netty5.util.Send;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

final class DefaultCompositeBuffer
extends ResourceSupport<Buffer, DefaultCompositeBuffer>
implements CompositeBuffer {
    private static final Drop<DefaultCompositeBuffer> COMPOSITE_DROP = new Drop<DefaultCompositeBuffer>(){

        @Override
        public void drop(DefaultCompositeBuffer buf) {
            RuntimeException re = null;
            for (Buffer b : buf.bufs) {
                try {
                    b.close();
                }
                catch (RuntimeException e) {
                    if (re == null) {
                        re = e;
                        continue;
                    }
                    re.addSuppressed(e);
                }
            }
        }

        @Override
        public Drop<DefaultCompositeBuffer> fork() {
            return this;
        }

        @Override
        public void attach(DefaultCompositeBuffer obj) {
        }

        public String toString() {
            return "COMPOSITE_DROP";
        }
    };
    private static final Buffer[] EMPTY_BUFFER_ARRAY = new Buffer[0];
    private static final int FIRST_AUTOMATIC_COMPONENT_SIZE = 256;
    private final BufferAllocator allocator;
    private final TornBufferAccessor tornBufAccessors;
    private Buffer[] bufs;
    private int[] offsets;
    private int capacity;
    private int roff;
    private int woff;
    private int subOffset;
    private boolean closed;
    private boolean readOnly;
    private int implicitCapacityLimit;

    public static CompositeBuffer compose(BufferAllocator allocator, Iterable<Send<Buffer>> sends) {
        ArrayList<Buffer> bufs = sends instanceof Collection ? new ArrayList(((Collection)sends).size()) : new ArrayList<Buffer>(4);
        RuntimeException receiveException = null;
        for (Send<Buffer> buf : sends) {
            if (receiveException != null) {
                try {
                    buf.close();
                }
                catch (Exception closeExc) {
                    receiveException.addSuppressed(closeExc);
                }
                continue;
            }
            try {
                bufs.add((Buffer)buf.receive());
            }
            catch (RuntimeException e) {
                receiveException = e;
                for (Buffer b : bufs) {
                    try {
                        b.close();
                    }
                    catch (Exception closeExc) {
                        receiveException.addSuppressed(closeExc);
                    }
                }
            }
        }
        if (receiveException != null) {
            throw receiveException;
        }
        return new DefaultCompositeBuffer(allocator, DefaultCompositeBuffer.filterExternalBufs(bufs), COMPOSITE_DROP);
    }

    public static CompositeBuffer compose(BufferAllocator allocator) {
        return new DefaultCompositeBuffer(allocator, EMPTY_BUFFER_ARRAY, COMPOSITE_DROP);
    }

    private static Buffer[] filterExternalBufs(Iterable<Buffer> externals) {
        Collector collector = new Collector(externals);
        collector.collect(externals);
        return collector.toArray();
    }

    private DefaultCompositeBuffer(BufferAllocator allocator, Buffer[] bufs, Drop<DefaultCompositeBuffer> drop) {
        super(drop);
        try {
            this.allocator = Objects.requireNonNull(allocator, "BufferAllocator cannot be null.");
            if (bufs.length > 0) {
                boolean targetReadOnly = bufs[0].readOnly();
                for (Buffer buf : bufs) {
                    if (buf.readOnly() == targetReadOnly) continue;
                    throw new IllegalArgumentException("Constituent buffers have inconsistent read-only state.");
                }
                this.readOnly = targetReadOnly;
            }
            this.bufs = bufs;
            this.computeBufferOffsets();
            this.implicitCapacityLimit = 0x7FFFFFF7;
            this.tornBufAccessors = new TornBufferAccessor(this);
        }
        catch (Exception e) {
            for (Buffer buf : bufs) {
                try {
                    buf.close();
                }
                catch (Exception closeExc) {
                    e.addSuppressed(closeExc);
                }
            }
            throw e;
        }
    }

    private void computeBufferOffsets() {
        int woff = 0;
        int roff = 0;
        if (this.bufs.length > 0) {
            boolean woffMidpoint = false;
            for (Buffer buf : this.bufs) {
                if (!woffMidpoint) {
                    woff += buf.writerOffset();
                    if (buf.writableBytes() <= 0) continue;
                    woffMidpoint = true;
                    continue;
                }
                if (buf.writerOffset() != 0) {
                    throw new AssertionError((Object)("The given buffers cannot be composed because they leave an unwritten gap: " + Arrays.toString(this.bufs) + "."));
                }
            }
            boolean roffMidpoint = false;
            for (Buffer buf : this.bufs) {
                if (!roffMidpoint) {
                    roff += buf.readerOffset();
                    if (buf.readableBytes() <= 0 && buf.writableBytes() <= 0) continue;
                    roffMidpoint = true;
                    continue;
                }
                if (buf.readerOffset() != 0) {
                    throw new AssertionError((Object)("The given buffers cannot be composed because they leave an unread gap: " + Arrays.toString(this.bufs) + "."));
                }
            }
        }
        this.woff = woff;
        this.roff = roff;
        this.offsets = new int[this.bufs.length];
        long cap = 0L;
        for (int i = 0; i < this.bufs.length; ++i) {
            this.offsets[i] = (int)cap;
            cap += (long)this.bufs[i].capacity();
        }
        if (cap > 0x7FFFFFF7L) {
            throw new IllegalArgumentException("Combined size of the constituent buffers is too big. The maximum buffer capacity is 2147483639 (Integer.MAX_VALUE - 8), but the sum of the constituent buffer capacities was " + cap + ".");
        }
        this.capacity = (int)cap;
    }

    public String toString() {
        return "Buffer[roff:" + this.roff + ", woff:" + this.woff + ", cap:" + this.capacity + "]";
    }

    @Override
    protected RuntimeException createResourceClosedException() {
        return InternalBufferUtils.bufferIsClosed(this);
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int readerOffset() {
        return this.roff;
    }

    @Override
    public CompositeBuffer readerOffset(int index) {
        this.checkReadBounds(index, 0);
        int indexLeft = index;
        for (Buffer buf : this.bufs) {
            buf.readerOffset(Math.min(indexLeft, buf.capacity()));
            indexLeft = Math.max(0, indexLeft - buf.capacity());
        }
        this.roff = index;
        return this;
    }

    @Override
    public int writerOffset() {
        return this.woff;
    }

    @Override
    public CompositeBuffer writerOffset(int index) {
        this.checkWriteBounds(index, 0);
        int indexLeft = index;
        for (Buffer buf : this.bufs) {
            buf.writerOffset(Math.min(indexLeft, buf.capacity()));
            indexLeft = Math.max(0, indexLeft - buf.capacity());
        }
        this.woff = index;
        return this;
    }

    @Override
    public CompositeBuffer fill(byte value) {
        if (this.closed) {
            throw InternalBufferUtils.bufferIsClosed(this);
        }
        for (Buffer buf : this.bufs) {
            buf.fill(value);
        }
        return this;
    }

    @Override
    public CompositeBuffer makeReadOnly() {
        for (Buffer buf : this.bufs) {
            buf.makeReadOnly();
        }
        this.readOnly = true;
        return this;
    }

    @Override
    public boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        for (Buffer buf : this.bufs) {
            if (buf.isDirect()) continue;
            return false;
        }
        return true;
    }

    @Override
    public CompositeBuffer implicitCapacityLimit(int limit) {
        InternalBufferUtils.checkImplicitCapacity(limit, this.capacity());
        this.implicitCapacityLimit = limit;
        return this;
    }

    @Override
    public int implicitCapacityLimit() {
        return this.implicitCapacityLimit;
    }

    @Override
    public CompositeBuffer copy(int offset, int length, boolean readOnly) {
        Buffer[] copies;
        InternalBufferUtils.checkLength(length);
        this.checkGetBounds(offset, length);
        if (this.closed) {
            throw InternalBufferUtils.bufferIsClosed(this);
        }
        if (this.bufs.length == 0) {
            assert (length == 0 && offset == 0);
            copies = this.bufs;
        } else {
            Buffer choice = (Buffer)this.chooseBuffer(offset, 0);
            if (length > 0) {
                copies = new Buffer[this.bufs.length];
                int off = this.subOffset;
                int cap = length;
                int j = 0;
                int i = this.searchOffsets(offset);
                while (cap > 0) {
                    Buffer buf = this.bufs[i];
                    int avail = buf.capacity() - off;
                    copies[j++] = buf.copy(off, Math.min(cap, avail), readOnly);
                    cap -= avail;
                    off = 0;
                    ++i;
                }
                copies = Arrays.copyOf(copies, j);
            } else {
                copies = new Buffer[]{choice.copy(this.subOffset, 0)};
            }
        }
        return new DefaultCompositeBuffer(this.allocator, copies, COMPOSITE_DROP);
    }

    @Override
    public void copyInto(int srcPos, byte[] dest, int destPos, int length) {
        this.copyInto(srcPos, (int s, Buffer b, int d, int l) -> b.copyInto(s, dest, d, l), destPos, length);
    }

    @Override
    public void copyInto(int srcPos, ByteBuffer dest, int destPos, int length) {
        if (dest.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.copyInto(srcPos, (int s, Buffer b, int d, int l) -> b.copyInto(s, dest, d, l), destPos, length);
    }

    private void copyInto(int srcPos, CopyInto dest, int destPos, int length) {
        if (!this.isAccessible()) {
            throw this.attachTrace(InternalBufferUtils.bufferIsClosed(this));
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length cannot be negative: " + length + ".");
        }
        if (srcPos < 0) {
            throw this.indexOutOfBounds(srcPos, false);
        }
        if (srcPos + length > this.capacity) {
            throw this.indexOutOfBounds(srcPos + length, false);
        }
        while (length > 0) {
            Buffer buf = (Buffer)this.chooseBuffer(srcPos, 0);
            int toCopy = Math.min(buf.capacity() - this.subOffset, length);
            dest.copyInto(this.subOffset, buf, destPos, toCopy);
            srcPos += toCopy;
            destPos += toCopy;
            length -= toCopy;
        }
    }

    @Override
    public void copyInto(int srcPos, Buffer dest, int destPos, int length) {
        if (!this.isAccessible()) {
            throw this.attachTrace(InternalBufferUtils.bufferIsClosed(this));
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length cannot be negative: " + length + ".");
        }
        if (srcPos < 0) {
            throw this.indexOutOfBounds(srcPos, false);
        }
        if (Math.addExact(srcPos, length) > this.capacity) {
            throw this.indexOutOfBounds(srcPos + length, false);
        }
        if (dest.readOnly()) {
            throw InternalBufferUtils.bufferIsReadOnly(dest);
        }
        if (length == 0) {
            return;
        }
        ByteCursor cursor = this.openReverseCursor(srcPos + length - 1, length);
        while (cursor.readByte()) {
            dest.setByte(destPos + --length, cursor.getByte());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int transferTo(WritableByteChannel channel, int length) throws IOException {
        if (!this.isAccessible()) {
            throw InternalBufferUtils.bufferIsClosed(this);
        }
        length = Math.min(this.readableBytes(), length);
        if (length == 0) {
            return 0;
        }
        this.checkReadBounds(this.readerOffset(), length);
        int totalBytesWritten = 0;
        try (ComponentIterator iterator = this.forEachComponent();){
            ByteBuffer[] byteBuffers = new ByteBuffer[this.countReadableComponents()];
            int counter = 0;
            BufferComponent c = (BufferComponent)iterator.firstReadable();
            while (c != null) {
                byteBuffers[counter++] = c.readableBuffer();
                c = (BufferComponent)((ComponentIterator.Next)((Object)c)).nextReadable();
            }
            int bufferCount = DefaultCompositeBuffer.countAndPrepareBuffersForChannelIO(length, byteBuffers);
            if (channel instanceof GatheringByteChannel) {
                GatheringByteChannel gatheringChannel = (GatheringByteChannel)channel;
                totalBytesWritten = Math.toIntExact(gatheringChannel.write(byteBuffers, 0, bufferCount));
            } else {
                for (int i = 0; i < bufferCount; ++i) {
                    int bytesWritten = channel.write(byteBuffers[i]);
                    totalBytesWritten = Math.addExact(totalBytesWritten, bytesWritten);
                }
            }
        }
        finally {
            this.skipReadableBytes(totalBytesWritten);
        }
        return totalBytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int transferFrom(FileChannel channel, long position, int length) throws IOException {
        ObjectUtil.checkPositiveOrZero((long)position, (String)"position");
        ObjectUtil.checkPositiveOrZero((int)length, (String)"length");
        if (!this.isAccessible()) {
            throw InternalBufferUtils.bufferIsClosed(this);
        }
        if (this.readOnly()) {
            throw InternalBufferUtils.bufferIsReadOnly(this);
        }
        length = Math.min(this.writableBytes(), length);
        if (length == 0) {
            return 0;
        }
        this.checkWriteBounds(this.writerOffset(), length);
        int totalBytesRead = 0;
        try (ComponentIterator iteration = this.forEachComponent();){
            ByteBuffer[] byteBuffers = new ByteBuffer[this.countWritableComponents()];
            int counter = 0;
            BufferComponent c = (BufferComponent)iteration.firstWritable();
            while (c != null) {
                byteBuffers[counter++] = c.writableBuffer();
                c = (BufferComponent)((ComponentIterator.Next)((Object)c)).nextWritable();
            }
            int bufferCount = DefaultCompositeBuffer.countAndPrepareBuffersForChannelIO(length, byteBuffers);
            int i = 0;
            while (true) {
                if (i >= bufferCount) break;
                int bytesRead = channel.read(byteBuffers[i], position + (long)totalBytesRead);
                if (bytesRead == -1) {
                    if (i == 0) {
                        int n = -1;
                        return n;
                    }
                    break;
                }
                totalBytesRead = Math.addExact(totalBytesRead, bytesRead);
                ++i;
            }
        }
        finally {
            if (totalBytesRead > 0) {
                this.skipWritableBytes(totalBytesRead);
            }
        }
        return totalBytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int transferFrom(ReadableByteChannel channel, int length) throws IOException {
        int totalBytesRead;
        block20: {
            if (!this.isAccessible()) {
                throw InternalBufferUtils.bufferIsClosed(this);
            }
            if (this.readOnly()) {
                throw InternalBufferUtils.bufferIsReadOnly(this);
            }
            length = Math.min(this.writableBytes(), length);
            if (length == 0) {
                return 0;
            }
            this.checkWriteBounds(this.writerOffset(), length);
            totalBytesRead = 0;
            ByteBuffer[] byteBuffers = new ByteBuffer[this.countWritableComponents()];
            try (ComponentIterator iteration = this.forEachComponent();){
                int counter = 0;
                BufferComponent c = (BufferComponent)iteration.firstWritable();
                while (c != null) {
                    byteBuffers[counter++] = c.writableBuffer();
                    c = (BufferComponent)((ComponentIterator.Next)((Object)c)).nextWritable();
                }
                int bufferCount = DefaultCompositeBuffer.countAndPrepareBuffersForChannelIO(length, byteBuffers);
                if (channel instanceof ScatteringByteChannel) {
                    ScatteringByteChannel scatteringChannel = (ScatteringByteChannel)channel;
                    totalBytesRead = Math.toIntExact(scatteringChannel.read(byteBuffers, 0, bufferCount));
                    break block20;
                }
                int i = 0;
                while (true) {
                    if (i >= bufferCount) break;
                    int bytesRead = channel.read(byteBuffers[i]);
                    if (bytesRead == -1) {
                        if (i == 0) {
                            int n = -1;
                            return n;
                        }
                        break;
                    }
                    totalBytesRead = Math.addExact(totalBytesRead, bytesRead);
                    ++i;
                }
            }
            finally {
                if (totalBytesRead > 0) {
                    this.skipWritableBytes(totalBytesRead);
                }
            }
        }
        return totalBytesRead;
    }

    private static int countAndPrepareBuffersForChannelIO(int byteLength, ByteBuffer[] byteBuffers) {
        int bufferCount = 0;
        int byteSum = 0;
        for (ByteBuffer buffer : byteBuffers) {
            ++bufferCount;
            if ((byteSum += buffer.remaining()) < byteLength) continue;
            int diff = byteSum - byteLength;
            if (diff <= 0) break;
            buffer.limit(buffer.limit() - diff);
            break;
        }
        return bufferCount;
    }

    @Override
    public int bytesBefore(byte needle) {
        if (!this.isAccessible()) {
            throw InternalBufferUtils.bufferIsClosed(this);
        }
        int length = this.readableBytes();
        int i = this.searchOffsets(this.readerOffset());
        int skip = 0;
        while (skip < length) {
            Buffer buf = this.bufs[i];
            int found = buf.bytesBefore(needle);
            if (found != -1) {
                return skip + found;
            }
            skip += buf.readableBytes();
            ++i;
        }
        return -1;
    }

    @Override
    public int bytesBefore(Buffer needle) {
        return InternalBufferUtils.bytesBefore(this, null, needle, null);
    }

    @Override
    public ByteCursor openCursor() {
        return this.openCursor(this.readerOffset(), this.readableBytes());
    }

    @Override
    public ByteCursor openCursor(int fromOffset, int length) {
        if (fromOffset < 0) {
            throw new IndexOutOfBoundsException("The fromOffset cannot be negative: " + fromOffset + ".");
        }
        InternalBufferUtils.checkLength(length);
        if (this.capacity < Math.addExact(fromOffset, length)) {
            throw new IndexOutOfBoundsException("The fromOffset+length is beyond the end of the buffer: fromOffset=" + fromOffset + ", length=" + length + ".");
        }
        if (this.closed) {
            throw InternalBufferUtils.bufferIsClosed(this);
        }
        int startBufferIndex = this.searchOffsets(fromOffset);
        int off = fromOffset - this.offsets[startBufferIndex];
        Buffer startBuf = this.bufs[startBufferIndex];
        ByteCursor startCursor = startBuf.openCursor(off, Math.min(startBuf.capacity() - off, length));
        return new ForwardCompositeByteCursor(this.bufs, fromOffset, length, startBufferIndex, startCursor);
    }

    @Override
    public ByteCursor openReverseCursor(int fromOffset, int length) {
        if (fromOffset < 0) {
            throw new IndexOutOfBoundsException("The fromOffset cannot be negative: " + fromOffset + ".");
        }
        InternalBufferUtils.checkLength(length);
        if (fromOffset - length < -1) {
            throw new IndexOutOfBoundsException("The fromOffset-length would underflow the buffer: fromOffset=" + fromOffset + ", length=" + length + ".");
        }
        if (this.closed) {
            throw InternalBufferUtils.bufferIsClosed(this);
        }
        int startBufferIndex = this.searchOffsets(fromOffset);
        int off = fromOffset - this.offsets[startBufferIndex];
        Buffer startBuf = this.bufs[startBufferIndex];
        ByteCursor startCursor = startBuf.openReverseCursor(off, Math.min(off + 1, length));
        return new ReverseCompositeByteCursor(this.bufs, fromOffset, length, startBufferIndex, startCursor);
    }

    @Override
    public CompositeBuffer ensureWritable(int size, int minimumGrowth, boolean allowCompaction) {
        if (!this.isAccessible()) {
            throw InternalBufferUtils.bufferIsClosed(this);
        }
        if (!this.isOwned()) {
            throw new IllegalStateException("Buffer is not owned. Only owned buffers can call ensureWritable.");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Cannot ensure writable for a negative size: " + size + ".");
        }
        if (minimumGrowth < 0) {
            throw new IllegalArgumentException("The minimum growth cannot be negative: " + minimumGrowth + ".");
        }
        if (this.readOnly) {
            throw InternalBufferUtils.bufferIsReadOnly(this);
        }
        if (this.writableBytes() >= size) {
            return this;
        }
        if (allowCompaction && size <= this.roff) {
            int compactableBuffers = 0;
            for (Buffer buf : this.bufs) {
                if (buf.capacity() != buf.readerOffset()) break;
                ++compactableBuffers;
            }
            if (compactableBuffers > 0) {
                Buffer[] compactable;
                if (compactableBuffers < this.bufs.length) {
                    compactable = new Buffer[compactableBuffers];
                    System.arraycopy(this.bufs, 0, compactable, 0, compactable.length);
                    System.arraycopy(this.bufs, compactable.length, this.bufs, 0, this.bufs.length - compactable.length);
                    System.arraycopy(compactable, 0, this.bufs, this.bufs.length - compactable.length, compactable.length);
                } else {
                    compactable = this.bufs;
                }
                for (Buffer buf : compactable) {
                    buf.resetOffsets();
                }
                this.computeBufferOffsets();
                if (this.writableBytes() >= size) {
                    return this;
                }
            } else if (this.bufs.length == 1) {
                this.bufs[0].compact();
                this.computeBufferOffsets();
                if (this.writableBytes() >= size) {
                    return this;
                }
            }
        }
        int growth = Math.max(size - this.writableBytes(), minimumGrowth);
        InternalBufferUtils.assertValidBufferSize((long)this.capacity() + (long)growth);
        Buffer extension = this.allocator.allocate(growth);
        this.unsafeExtendWith(extension);
        return this;
    }

    @Override
    public CompositeBuffer extendWith(Send<Buffer> extension) {
        Buffer buffer = (Buffer)Objects.requireNonNull(extension, "Extension buffer cannot be null.").receive();
        if (!this.isAccessible() || !this.isOwned()) {
            buffer.close();
            if (!this.isAccessible()) {
                throw InternalBufferUtils.bufferIsClosed(this);
            }
            throw new IllegalStateException("This buffer cannot be extended because it is not in an owned state.");
        }
        if (this.bufs.length > 0 && buffer.readOnly() != this.readOnly()) {
            buffer.close();
            throw new IllegalArgumentException("This buffer is " + (this.readOnly ? "read-only" : "writable") + ", and cannot be extended with a buffer that is " + (buffer.readOnly() ? "read-only." : "writable."));
        }
        long extensionCapacity = buffer.capacity();
        if (extensionCapacity == 0L) {
            buffer.close();
            return this;
        }
        long newSize = (long)this.capacity() + extensionCapacity;
        InternalBufferUtils.assertValidBufferSize(newSize);
        Buffer[] restoreTemp = this.bufs;
        try {
            Buffer[] concatArray = Arrays.copyOf(this.bufs, this.bufs.length + 1);
            concatArray[this.bufs.length] = buffer;
            this.bufs = DefaultCompositeBuffer.filterExternalBufs(Arrays.asList(concatArray));
            this.computeBufferOffsets();
            if (restoreTemp.length == 0) {
                this.readOnly = buffer.readOnly();
            }
        }
        catch (Exception e) {
            this.bufs = restoreTemp;
            throw e;
        }
        return this;
    }

    private void unsafeExtendWith(Buffer extension) {
        this.bufs = Arrays.copyOf(this.bufs, this.bufs.length + 1);
        this.bufs[this.bufs.length - 1] = extension;
        this.computeBufferOffsets();
    }

    private void checkSplit(int splitOffset) {
        if (splitOffset < 0) {
            throw new IllegalArgumentException("The split offset cannot be negative: " + splitOffset + ".");
        }
        if (this.capacity() < splitOffset) {
            throw new IllegalArgumentException("The split offset cannot be greater than the buffer capacity, but the split offset was " + splitOffset + ", and capacity is " + this.capacity() + ".");
        }
        if (!this.isAccessible()) {
            throw this.attachTrace(InternalBufferUtils.bufferIsClosed(this));
        }
        if (!this.isOwned()) {
            throw new IllegalStateException("Cannot split a buffer that is not owned.");
        }
    }

    @Override
    public CompositeBuffer split() {
        return this.split(this.writerOffset());
    }

    @Override
    public CompositeBuffer split(int splitOffset) {
        this.checkSplit(splitOffset);
        if (this.bufs.length == 0) {
            return new DefaultCompositeBuffer(this.allocator, this.bufs, this.unsafeGetDrop());
        }
        int i = this.searchOffsets(splitOffset);
        int off = splitOffset - this.offsets[i];
        Buffer[] splits = Arrays.copyOf(this.bufs, off == 0 ? i : 1 + i);
        this.bufs = Arrays.copyOfRange(this.bufs, off == this.bufs[i].capacity() ? 1 + i : i, this.bufs.length);
        if (off > 0 && splits.length > 0 && off < splits[splits.length - 1].capacity()) {
            splits[splits.length - 1] = this.bufs[0].split(off);
        }
        this.computeBufferOffsets();
        return this.buildSplitBuffer(splits);
    }

    private CompositeBuffer buildSplitBuffer(Buffer[] splits) {
        return new DefaultCompositeBuffer(this.allocator, splits, this.unsafeGetDrop());
    }

    @Override
    public CompositeBuffer splitComponentsFloor(int splitOffset) {
        this.checkSplit(splitOffset);
        if (this.bufs.length == 0) {
            return new DefaultCompositeBuffer(this.allocator, this.bufs, this.unsafeGetDrop());
        }
        int i = this.searchOffsets(splitOffset);
        int off = splitOffset - this.offsets[i];
        if (off == this.bufs[i].capacity()) {
            ++i;
        }
        Buffer[] splits = Arrays.copyOf(this.bufs, i);
        this.bufs = Arrays.copyOfRange(this.bufs, i, this.bufs.length);
        this.computeBufferOffsets();
        return this.buildSplitBuffer(splits);
    }

    @Override
    public CompositeBuffer splitComponentsCeil(int splitOffset) {
        this.checkSplit(splitOffset);
        if (this.bufs.length == 0) {
            return new DefaultCompositeBuffer(this.allocator, this.bufs, this.unsafeGetDrop());
        }
        int i = this.searchOffsets(splitOffset);
        int off = splitOffset - this.offsets[i];
        if (0 < off && off <= this.bufs[i].capacity()) {
            ++i;
        }
        Buffer[] splits = Arrays.copyOf(this.bufs, i);
        this.bufs = Arrays.copyOfRange(this.bufs, i, this.bufs.length);
        this.computeBufferOffsets();
        return this.buildSplitBuffer(splits);
    }

    @Override
    public Buffer[] decomposeBuffer() {
        Buffer[] result = this.bufs;
        this.bufs = EMPTY_BUFFER_ARRAY;
        try {
            this.close();
        }
        catch (Throwable e) {
            for (Buffer buffer : result) {
                try {
                    buffer.close();
                }
                catch (Throwable ex) {
                    e.addSuppressed(ex);
                }
            }
            throw e;
        }
        return result;
    }

    @Override
    public CompositeBuffer compact() {
        if (!this.isAccessible()) {
            throw this.attachTrace(InternalBufferUtils.bufferIsClosed(this));
        }
        if (!this.isOwned()) {
            throw this.attachTrace(new IllegalStateException("Buffer must be owned in order to compact."));
        }
        if (this.readOnly()) {
            throw new BufferReadOnlyException("Buffer must be writable in order to compact, but was read-only.");
        }
        int distance = this.roff;
        if (distance == 0) {
            return this;
        }
        int pos = 0;
        ByteCursor cursor = this.openCursor();
        while (cursor.readByte()) {
            this.setByte(pos, cursor.getByte());
            ++pos;
        }
        this.readerOffset(0);
        this.writerOffset(this.woff - distance);
        return this;
    }

    @Override
    public int countComponents() {
        int sum = 0;
        for (Buffer buf : this.bufs) {
            sum += buf.countComponents();
        }
        return sum;
    }

    @Override
    public int countReadableComponents() {
        int sum = 0;
        for (Buffer buf : this.bufs) {
            sum += buf.countReadableComponents();
        }
        return sum;
    }

    @Override
    public int countWritableComponents() {
        int sum = 0;
        for (Buffer buf : this.bufs) {
            sum += buf.countWritableComponents();
        }
        return sum;
    }

    @Override
    public <T extends BufferComponent & ComponentIterator.Next> ComponentIterator<T> forEachComponent() {
        return new CompositeComponentIterator((DefaultCompositeBuffer)this.acquire());
    }

    @Override
    public byte readByte() {
        return this.prepRead(1).readByte();
    }

    @Override
    public byte getByte(int roff) {
        return this.prepGet(roff, 1).getByte(this.subOffset);
    }

    @Override
    public int readUnsignedByte() {
        return this.prepRead(1).readUnsignedByte();
    }

    @Override
    public int getUnsignedByte(int roff) {
        return this.prepGet(roff, 1).getUnsignedByte(this.subOffset);
    }

    @Override
    public CompositeBuffer writeByte(byte value) {
        this.prepWrite(1).writeByte(value);
        return this;
    }

    @Override
    public CompositeBuffer setByte(int woff, byte value) {
        this.prepWrite(woff, 1).setByte(this.subOffset, value);
        return this;
    }

    @Override
    public CompositeBuffer writeUnsignedByte(int value) {
        this.prepWrite(1).writeUnsignedByte(value);
        return this;
    }

    @Override
    public CompositeBuffer setUnsignedByte(int woff, int value) {
        this.prepWrite(woff, 1).setUnsignedByte(this.subOffset, value);
        return this;
    }

    @Override
    public char readChar() {
        return this.prepRead(2).readChar();
    }

    @Override
    public char getChar(int roff) {
        return this.prepGet(roff, 2).getChar(this.subOffset);
    }

    @Override
    public CompositeBuffer writeChar(char value) {
        this.prepWrite(2).writeChar(value);
        return this;
    }

    @Override
    public CompositeBuffer setChar(int woff, char value) {
        this.prepWrite(woff, 2).setChar(this.subOffset, value);
        return this;
    }

    @Override
    public short readShort() {
        return this.prepRead(2).readShort();
    }

    @Override
    public short getShort(int roff) {
        return this.prepGet(roff, 2).getShort(this.subOffset);
    }

    @Override
    public int readUnsignedShort() {
        return this.prepRead(2).readUnsignedShort();
    }

    @Override
    public int getUnsignedShort(int roff) {
        return this.prepGet(roff, 2).getUnsignedShort(this.subOffset);
    }

    @Override
    public CompositeBuffer writeShort(short value) {
        this.prepWrite(2).writeShort(value);
        return this;
    }

    @Override
    public CompositeBuffer setShort(int woff, short value) {
        this.prepWrite(woff, 2).setShort(this.subOffset, value);
        return this;
    }

    @Override
    public CompositeBuffer writeUnsignedShort(int value) {
        this.prepWrite(2).writeUnsignedShort(value);
        return this;
    }

    @Override
    public CompositeBuffer setUnsignedShort(int woff, int value) {
        this.prepWrite(woff, 2).setUnsignedShort(this.subOffset, value);
        return this;
    }

    @Override
    public int readMedium() {
        return this.prepRead(3).readMedium();
    }

    @Override
    public int getMedium(int roff) {
        return this.prepGet(roff, 3).getMedium(this.subOffset);
    }

    @Override
    public int readUnsignedMedium() {
        return this.prepRead(3).readUnsignedMedium();
    }

    @Override
    public int getUnsignedMedium(int roff) {
        return this.prepGet(roff, 3).getUnsignedMedium(this.subOffset);
    }

    @Override
    public CompositeBuffer writeMedium(int value) {
        this.prepWrite(3).writeMedium(value);
        return this;
    }

    @Override
    public CompositeBuffer setMedium(int woff, int value) {
        this.prepWrite(woff, 3).setMedium(this.subOffset, value);
        return this;
    }

    @Override
    public CompositeBuffer writeUnsignedMedium(int value) {
        this.prepWrite(3).writeUnsignedMedium(value);
        return this;
    }

    @Override
    public CompositeBuffer setUnsignedMedium(int woff, int value) {
        this.prepWrite(woff, 3).setUnsignedMedium(this.subOffset, value);
        return this;
    }

    @Override
    public int readInt() {
        return this.prepRead(4).readInt();
    }

    @Override
    public int getInt(int roff) {
        return this.prepGet(roff, 4).getInt(this.subOffset);
    }

    @Override
    public long readUnsignedInt() {
        return this.prepRead(4).readUnsignedInt();
    }

    @Override
    public long getUnsignedInt(int roff) {
        return this.prepGet(roff, 4).getUnsignedInt(this.subOffset);
    }

    @Override
    public CompositeBuffer writeInt(int value) {
        this.prepWrite(4).writeInt(value);
        return this;
    }

    @Override
    public CompositeBuffer setInt(int woff, int value) {
        this.prepWrite(woff, 4).setInt(this.subOffset, value);
        return this;
    }

    @Override
    public CompositeBuffer writeUnsignedInt(long value) {
        this.prepWrite(4).writeUnsignedInt(value);
        return this;
    }

    @Override
    public CompositeBuffer setUnsignedInt(int woff, long value) {
        this.prepWrite(woff, 4).setUnsignedInt(this.subOffset, value);
        return this;
    }

    @Override
    public float readFloat() {
        return this.prepRead(4).readFloat();
    }

    @Override
    public float getFloat(int roff) {
        return this.prepGet(roff, 4).getFloat(this.subOffset);
    }

    @Override
    public CompositeBuffer writeFloat(float value) {
        this.prepWrite(4).writeFloat(value);
        return this;
    }

    @Override
    public CompositeBuffer setFloat(int woff, float value) {
        this.prepWrite(woff, 4).setFloat(this.subOffset, value);
        return this;
    }

    @Override
    public long readLong() {
        return this.prepRead(8).readLong();
    }

    @Override
    public long getLong(int roff) {
        return this.prepGet(roff, 8).getLong(this.subOffset);
    }

    @Override
    public CompositeBuffer writeLong(long value) {
        this.prepWrite(8).writeLong(value);
        return this;
    }

    @Override
    public CompositeBuffer setLong(int woff, long value) {
        this.prepWrite(woff, 8).setLong(this.subOffset, value);
        return this;
    }

    @Override
    public double readDouble() {
        return this.prepRead(8).readDouble();
    }

    @Override
    public double getDouble(int roff) {
        return this.prepGet(roff, 8).getDouble(this.subOffset);
    }

    @Override
    public CompositeBuffer writeDouble(double value) {
        this.prepWrite(8).writeDouble(value);
        return this;
    }

    @Override
    public CompositeBuffer setDouble(int woff, double value) {
        this.prepWrite(woff, 8).setDouble(this.subOffset, value);
        return this;
    }

    @Override
    protected Owned<DefaultCompositeBuffer> prepareSend() {
        Send[] sends = new Send[this.bufs.length];
        try {
            for (int i = 0; i < this.bufs.length; ++i) {
                sends[i] = this.bufs[i].send();
            }
        }
        catch (Throwable throwable) {
            for (int i = 0; i < sends.length; ++i) {
                if (sends[i] == null) continue;
                try {
                    this.bufs[i] = (Buffer)sends[i].receive();
                    continue;
                }
                catch (Exception e) {
                    throwable.addSuppressed(e);
                }
            }
            throw throwable;
        }
        boolean readOnly = this.readOnly;
        int implicitCapacityLimit = this.implicitCapacityLimit;
        return drop -> {
            Buffer[] received = new Buffer[sends.length];
            for (int i = 0; i < sends.length; ++i) {
                received[i] = (Buffer)sends[i].receive();
            }
            DefaultCompositeBuffer composite = new DefaultCompositeBuffer(this.allocator, received, drop);
            composite.readOnly = readOnly;
            composite.implicitCapacityLimit = implicitCapacityLimit;
            drop.attach(composite);
            return composite;
        };
    }

    @Override
    protected void makeInaccessible() {
        this.capacity = 0;
        this.roff = 0;
        this.woff = 0;
        this.readOnly = false;
        this.closed = true;
    }

    @Override
    protected boolean isOwned() {
        return super.isOwned() && this.allConstituentsAreOwned();
    }

    @Override
    public CompositeBuffer touch(Object hint) {
        super.touch(hint);
        for (Buffer buf : this.bufs) {
            buf.touch(hint);
        }
        return this;
    }

    private boolean allConstituentsAreOwned() {
        boolean result = true;
        for (Buffer buf : this.bufs) {
            result &= InternalBufferUtils.isOwned((ResourceSupport)((Object)buf));
        }
        return result;
    }

    long readPassThrough() {
        BufferAccessor buf = this.choosePassThroughBuffer(this.subOffset++);
        assert (buf != this.tornBufAccessors) : "Recursive call to torn buffer.";
        return buf.readUnsignedByte();
    }

    void writePassThrough(int value) {
        BufferAccessor buf = this.choosePassThroughBuffer(this.subOffset++);
        assert (buf != this.tornBufAccessors) : "Recursive call to torn buffer.";
        buf.writeUnsignedByte(value);
    }

    long getPassThrough(int roff) {
        BufferAccessor buf = this.chooseBuffer(roff, 1);
        assert (buf != this.tornBufAccessors) : "Recursive call to torn buffer.";
        return buf.getUnsignedByte(this.subOffset);
    }

    void setPassThrough(int woff, int value) {
        BufferAccessor buf = this.chooseBuffer(woff, 1);
        assert (buf != this.tornBufAccessors) : "Recursive call to torn buffer.";
        buf.setUnsignedByte(this.subOffset, value);
    }

    private BufferAccessor prepRead(int size) {
        BufferAccessor buf = this.prepRead(this.roff, size);
        this.roff += size;
        return buf;
    }

    private BufferAccessor prepRead(int index, int size) {
        this.checkReadBounds(index, size);
        return this.chooseBuffer(index, size);
    }

    private void checkReadBounds(int index, int size) {
        if (index < 0 || this.woff < index + size) {
            throw this.indexOutOfBounds(index, false);
        }
    }

    private BufferAccessor prepGet(int index, int size) {
        this.checkGetBounds(index, size);
        return this.chooseBuffer(index, size);
    }

    private void checkGetBounds(int index, int size) {
        if (index < 0 || this.capacity < index + size) {
            throw this.indexOutOfBounds(index, false);
        }
    }

    private BufferAccessor prepWrite(int size) {
        if (this.writableBytes() < size && this.woff + size <= this.implicitCapacityLimit && this.isOwned()) {
            int minGrowth = this.bufs.length == 0 ? Math.min(this.implicitCapacityLimit, 256) : Math.min(Math.max(PlatformDependent.roundToPowerOfTwo((int)(this.capacity() / this.bufs.length)), size), this.implicitCapacityLimit - this.capacity);
            this.ensureWritable(size, minGrowth, false);
        }
        BufferAccessor buf = this.prepWrite(this.woff, size);
        this.woff += size;
        return buf;
    }

    private BufferAccessor prepWrite(int index, int size) {
        this.checkWriteBounds(index, size);
        return this.chooseBuffer(index, size);
    }

    private void checkWriteBounds(int index, int size) {
        if (index < 0 || this.capacity < index + size || this.readOnly) {
            throw this.indexOutOfBounds(index, true);
        }
    }

    private RuntimeException indexOutOfBounds(int index, boolean write) {
        if (this.closed) {
            return InternalBufferUtils.bufferIsClosed(this);
        }
        if (write && this.readOnly) {
            return InternalBufferUtils.bufferIsReadOnly(this);
        }
        return new IndexOutOfBoundsException("Index " + index + " is out of bounds: [read 0 to " + this.woff + ", write 0 to " + this.capacity + "].");
    }

    private BufferAccessor chooseBuffer(int index, int size) {
        int i = this.searchOffsets(index);
        if (i == this.bufs.length) {
            return null;
        }
        int off = index - this.offsets[i];
        Buffer candidate = this.bufs[i];
        if (off + size <= candidate.capacity()) {
            this.subOffset = off;
            return candidate;
        }
        this.subOffset = index;
        return this.tornBufAccessors;
    }

    private BufferAccessor choosePassThroughBuffer(int index) {
        int i = this.searchOffsets(index);
        return this.bufs[i];
    }

    private int searchOffsets(int index) {
        int i = Arrays.binarySearch(this.offsets, index);
        return i < 0 ? -(i + 2) : i;
    }

    public boolean equals(Object o) {
        return o instanceof Buffer && InternalBufferUtils.equals(this, (Buffer)o);
    }

    public int hashCode() {
        return InternalBufferUtils.hashCode(this);
    }

    private static final class NextComponent<T extends ComponentIterator.Next & BufferComponent>
    implements BufferComponent,
    ComponentIterator.Next,
    SafeCloseable {
        private final DefaultCompositeBuffer compositeBuffer;
        private final Buffer[] bufs;
        int nextIndex;
        ComponentIterator<T> currentItr;
        T currentComponent;
        int currentReadSkip;
        int currentWriteSkip;

        private NextComponent(DefaultCompositeBuffer compositeBuffer) {
            this.compositeBuffer = compositeBuffer;
            this.bufs = compositeBuffer.bufs;
            this.nextComponent();
        }

        @Override
        public <N extends ComponentIterator.Next & BufferComponent> N next() {
            if (this.currentComponent == null) {
                return null;
            }
            this.nextComponent();
            return (N)(this.currentComponent != null ? this : null);
        }

        private void nextComponent() {
            if (this.currentComponent != null) {
                this.currentComponent = this.currentComponent.next();
            }
            while (this.currentComponent == null) {
                if (this.currentItr != null) {
                    this.currentItr.close();
                    this.currentItr = null;
                }
                if (this.nextIndex >= this.bufs.length) {
                    return;
                }
                this.currentItr = this.bufs[this.nextIndex].forEachComponent();
                ++this.nextIndex;
                this.currentComponent = this.currentItr.first();
            }
        }

        @Override
        public boolean hasReadableArray() {
            return ((BufferComponent)this.currentComponent).hasReadableArray();
        }

        @Override
        public byte[] readableArray() {
            return ((BufferComponent)this.currentComponent).readableArray();
        }

        @Override
        public int readableArrayOffset() {
            return ((BufferComponent)this.currentComponent).readableArrayOffset();
        }

        @Override
        public int readableArrayLength() {
            return ((BufferComponent)this.currentComponent).readableArrayLength();
        }

        @Override
        public long baseNativeAddress() {
            return ((BufferComponent)this.currentComponent).baseNativeAddress();
        }

        @Override
        public long readableNativeAddress() {
            return ((BufferComponent)this.currentComponent).readableNativeAddress();
        }

        @Override
        public ByteBuffer readableBuffer() {
            return ((BufferComponent)this.currentComponent).readableBuffer();
        }

        @Override
        public int readableBytes() {
            return ((BufferComponent)this.currentComponent).readableBytes();
        }

        @Override
        public ByteCursor openCursor() {
            return ((BufferComponent)this.currentComponent).openCursor();
        }

        @Override
        public BufferComponent skipReadableBytes(int byteCount) {
            ((BufferComponent)this.currentComponent).skipReadableBytes(byteCount);
            this.compositeBuffer.readerOffset(this.currentReadSkip + byteCount);
            this.currentReadSkip += byteCount;
            return this;
        }

        @Override
        public boolean hasWritableArray() {
            return ((BufferComponent)this.currentComponent).hasWritableArray();
        }

        @Override
        public byte[] writableArray() {
            return ((BufferComponent)this.currentComponent).writableArray();
        }

        @Override
        public int writableArrayOffset() {
            return ((BufferComponent)this.currentComponent).writableArrayOffset();
        }

        @Override
        public int writableArrayLength() {
            return ((BufferComponent)this.currentComponent).writableArrayLength();
        }

        @Override
        public long writableNativeAddress() {
            return ((BufferComponent)this.currentComponent).writableNativeAddress();
        }

        @Override
        public int writableBytes() {
            return ((BufferComponent)this.currentComponent).writableBytes();
        }

        @Override
        public ByteBuffer writableBuffer() {
            return ((BufferComponent)this.currentComponent).writableBuffer();
        }

        @Override
        public BufferComponent skipWritableBytes(int byteCount) {
            ((BufferComponent)this.currentComponent).skipWritableBytes(byteCount);
            this.compositeBuffer.writerOffset(this.currentWriteSkip + byteCount);
            this.currentWriteSkip += byteCount;
            return this;
        }

        public void close() {
            this.currentComponent = null;
            if (this.currentItr != null) {
                this.currentItr.close();
                this.currentItr = null;
            }
        }
    }

    private static final class CompositeComponentIterator<T extends ComponentIterator.Next & BufferComponent>
    implements ComponentIterator<T> {
        private final DefaultCompositeBuffer compositeBuffer;
        NextComponent<T> readableNext;

        private CompositeComponentIterator(DefaultCompositeBuffer compositeBuffer) {
            this.compositeBuffer = compositeBuffer;
        }

        @Override
        public T first() {
            NextComponent nextComponent;
            if (this.compositeBuffer.bufs.length > 0) {
                this.readableNext = new NextComponent(this.compositeBuffer);
                nextComponent = this.readableNext;
            } else {
                nextComponent = null;
            }
            return (T)nextComponent;
        }

        public void close() {
            if (this.readableNext != null) {
                this.readableNext.close();
            }
            this.compositeBuffer.close();
        }
    }

    private static final class ReverseCompositeByteCursor
    implements ByteCursor {
        final Buffer[] bufs;
        int index;
        final int end;
        int bufferIndex;
        int initOffset;
        ByteCursor cursor;
        byte byteValue;

        ReverseCompositeByteCursor(Buffer[] bufs, int fromOffset, int length, int startBufferIndex, ByteCursor startCursor) {
            this.bufs = bufs;
            this.index = fromOffset;
            this.end = fromOffset - length;
            this.bufferIndex = startBufferIndex;
            this.initOffset = startCursor.currentOffset();
            this.cursor = startCursor;
            this.byteValue = (byte)-1;
        }

        @Override
        public boolean readByte() {
            if (this.cursor.readByte()) {
                this.byteValue = this.cursor.getByte();
                return true;
            }
            if (this.bytesLeft() > 0) {
                this.nextCursor();
                this.cursor.readByte();
                this.byteValue = this.cursor.getByte();
                return true;
            }
            return false;
        }

        private void nextCursor() {
            --this.bufferIndex;
            Buffer nextBuf = this.bufs[this.bufferIndex];
            int length = Math.min(nextBuf.capacity(), this.bytesLeft());
            int offset = nextBuf.capacity() - 1;
            this.cursor = nextBuf.openReverseCursor(offset, length);
            this.initOffset = offset;
        }

        @Override
        public byte getByte() {
            return this.byteValue;
        }

        @Override
        public int currentOffset() {
            int currOff = this.cursor.currentOffset();
            this.index -= this.initOffset - currOff;
            this.initOffset = currOff;
            return this.index;
        }

        @Override
        public int bytesLeft() {
            return this.currentOffset() - this.end;
        }
    }

    private static final class ForwardCompositeByteCursor
    implements ByteCursor {
        final Buffer[] bufs;
        int index;
        final int end;
        int bufferIndex;
        int initOffset;
        ByteCursor cursor;
        byte byteValue;

        ForwardCompositeByteCursor(Buffer[] bufs, int fromOffset, int length, int startBufferIndex, ByteCursor startCursor) {
            this.bufs = bufs;
            this.index = fromOffset;
            this.end = fromOffset + length;
            this.bufferIndex = startBufferIndex;
            this.initOffset = startCursor.currentOffset();
            this.cursor = startCursor;
            this.byteValue = (byte)-1;
        }

        @Override
        public boolean readByte() {
            if (this.cursor.readByte()) {
                this.byteValue = this.cursor.getByte();
                return true;
            }
            if (this.bytesLeft() > 0) {
                this.nextCursor();
                this.cursor.readByte();
                this.byteValue = this.cursor.getByte();
                return true;
            }
            return false;
        }

        private void nextCursor() {
            ++this.bufferIndex;
            Buffer nextBuf = this.bufs[this.bufferIndex];
            this.cursor = nextBuf.openCursor(0, Math.min(nextBuf.capacity(), this.bytesLeft()));
            this.initOffset = 0;
        }

        @Override
        public byte getByte() {
            return this.byteValue;
        }

        @Override
        public int currentOffset() {
            int currOff = this.cursor.currentOffset();
            this.index += currOff - this.initOffset;
            this.initOffset = currOff;
            return this.index;
        }

        @Override
        public int bytesLeft() {
            return this.end - this.currentOffset();
        }
    }

    private static final class TornBufferAccessor
    implements BufferAccessor {
        private final DefaultCompositeBuffer buf;

        private TornBufferAccessor(DefaultCompositeBuffer buf) {
            this.buf = buf;
        }

        @Override
        public byte readByte() {
            throw new AssertionError((Object)"Method should not be used.");
        }

        @Override
        public byte getByte(int roff) {
            throw new AssertionError((Object)"Method should not be used.");
        }

        @Override
        public int readUnsignedByte() {
            throw new AssertionError((Object)"Method should not be used.");
        }

        @Override
        public int getUnsignedByte(int roff) {
            throw new AssertionError((Object)"Method should not be used.");
        }

        @Override
        public Buffer writeByte(byte value) {
            throw new AssertionError((Object)"Method should not be used.");
        }

        @Override
        public Buffer setByte(int woff, byte value) {
            throw new AssertionError((Object)"Method should not be used.");
        }

        @Override
        public Buffer writeUnsignedByte(int value) {
            throw new AssertionError((Object)"Method should not be used.");
        }

        @Override
        public Buffer setUnsignedByte(int woff, int value) {
            throw new AssertionError((Object)"Method should not be used.");
        }

        @Override
        public char readChar() {
            return (char)(this.read() << 8 | this.read());
        }

        @Override
        public char getChar(int roff) {
            return (char)(this.read(roff) << 8 | this.read(roff + 1));
        }

        @Override
        public Buffer writeChar(char value) {
            this.write(value >>> 8);
            this.write(value & 0xFF);
            return this.buf;
        }

        @Override
        public Buffer setChar(int woff, char value) {
            this.write(woff, value >>> 8);
            this.write(woff + 1, value & 0xFF);
            return this.buf;
        }

        @Override
        public short readShort() {
            return (short)(this.read() << 8 | this.read());
        }

        @Override
        public short getShort(int roff) {
            return (short)(this.read(roff) << 8 | this.read(roff + 1));
        }

        @Override
        public int readUnsignedShort() {
            return (int)(this.read() << 8 | this.read()) & 0xFFFF;
        }

        @Override
        public int getUnsignedShort(int roff) {
            return (int)(this.read(roff) << 8 | this.read(roff + 1)) & 0xFFFF;
        }

        @Override
        public Buffer writeShort(short value) {
            this.write(value >>> 8);
            this.write(value & 0xFF);
            return this.buf;
        }

        @Override
        public Buffer setShort(int woff, short value) {
            this.write(woff, value >>> 8);
            this.write(woff + 1, value & 0xFF);
            return this.buf;
        }

        @Override
        public Buffer writeUnsignedShort(int value) {
            this.write(value >>> 8);
            this.write(value & 0xFF);
            return this.buf;
        }

        @Override
        public Buffer setUnsignedShort(int woff, int value) {
            this.write(woff, value >>> 8);
            this.write(woff + 1, value & 0xFF);
            return this.buf;
        }

        @Override
        public int readMedium() {
            return (int)(this.read() << 16 | this.read() << 8 | this.read());
        }

        @Override
        public int getMedium(int roff) {
            return (int)(this.read(roff) << 16 | this.read(roff + 1) << 8 | this.read(roff + 2));
        }

        @Override
        public int readUnsignedMedium() {
            return (int)(this.read() << 16 | this.read() << 8 | this.read()) & 0xFFFFFF;
        }

        @Override
        public int getUnsignedMedium(int roff) {
            return (int)(this.read(roff) << 16 | this.read(roff + 1) << 8 | this.read(roff + 2)) & 0xFFFFFF;
        }

        @Override
        public Buffer writeMedium(int value) {
            this.write(value >>> 16);
            this.write(value >>> 8 & 0xFF);
            this.write(value & 0xFF);
            return this.buf;
        }

        @Override
        public Buffer setMedium(int woff, int value) {
            this.write(woff, value >>> 16);
            this.write(woff + 1, value >>> 8 & 0xFF);
            this.write(woff + 2, value & 0xFF);
            return this.buf;
        }

        @Override
        public Buffer writeUnsignedMedium(int value) {
            this.write(value >>> 16);
            this.write(value >>> 8 & 0xFF);
            this.write(value & 0xFF);
            return this.buf;
        }

        @Override
        public Buffer setUnsignedMedium(int woff, int value) {
            this.write(woff, value >>> 16);
            this.write(woff + 1, value >>> 8 & 0xFF);
            this.write(woff + 2, value & 0xFF);
            return this.buf;
        }

        @Override
        public int readInt() {
            return (int)(this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read());
        }

        @Override
        public int getInt(int roff) {
            return (int)(this.read(roff) << 24 | this.read(roff + 1) << 16 | this.read(roff + 2) << 8 | this.read(roff + 3));
        }

        @Override
        public long readUnsignedInt() {
            return (this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read()) & 0xFFFFFFFFL;
        }

        @Override
        public long getUnsignedInt(int roff) {
            return (this.read(roff) << 24 | this.read(roff + 1) << 16 | this.read(roff + 2) << 8 | this.read(roff + 3)) & 0xFFFFFFFFL;
        }

        @Override
        public Buffer writeInt(int value) {
            this.write(value >>> 24);
            this.write(value >>> 16 & 0xFF);
            this.write(value >>> 8 & 0xFF);
            this.write(value & 0xFF);
            return this.buf;
        }

        @Override
        public Buffer setInt(int woff, int value) {
            this.write(woff, value >>> 24);
            this.write(woff + 1, value >>> 16 & 0xFF);
            this.write(woff + 2, value >>> 8 & 0xFF);
            this.write(woff + 3, value & 0xFF);
            return this.buf;
        }

        @Override
        public Buffer writeUnsignedInt(long value) {
            this.write((int)(value >>> 24));
            this.write((int)(value >>> 16 & 0xFFL));
            this.write((int)(value >>> 8 & 0xFFL));
            this.write((int)(value & 0xFFL));
            return this.buf;
        }

        @Override
        public Buffer setUnsignedInt(int woff, long value) {
            this.write(woff, (int)(value >>> 24));
            this.write(woff + 1, (int)(value >>> 16 & 0xFFL));
            this.write(woff + 2, (int)(value >>> 8 & 0xFFL));
            this.write(woff + 3, (int)(value & 0xFFL));
            return this.buf;
        }

        @Override
        public float readFloat() {
            return Float.intBitsToFloat(this.readInt());
        }

        @Override
        public float getFloat(int roff) {
            return Float.intBitsToFloat(this.getInt(roff));
        }

        @Override
        public Buffer writeFloat(float value) {
            return this.writeUnsignedInt(Float.floatToRawIntBits(value));
        }

        @Override
        public Buffer setFloat(int woff, float value) {
            return this.setUnsignedInt(woff, Float.floatToRawIntBits(value));
        }

        @Override
        public long readLong() {
            return this.read() << 56 | this.read() << 48 | this.read() << 40 | this.read() << 32 | this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
        }

        @Override
        public long getLong(int roff) {
            return this.read(roff) << 56 | this.read(roff + 1) << 48 | this.read(roff + 2) << 40 | this.read(roff + 3) << 32 | this.read(roff + 4) << 24 | this.read(roff + 5) << 16 | this.read(roff + 6) << 8 | this.read(roff + 7);
        }

        @Override
        public Buffer writeLong(long value) {
            this.write((int)(value >>> 56));
            this.write((int)(value >>> 48 & 0xFFL));
            this.write((int)(value >>> 40 & 0xFFL));
            this.write((int)(value >>> 32 & 0xFFL));
            this.write((int)(value >>> 24 & 0xFFL));
            this.write((int)(value >>> 16 & 0xFFL));
            this.write((int)(value >>> 8 & 0xFFL));
            this.write((int)(value & 0xFFL));
            return this.buf;
        }

        @Override
        public Buffer setLong(int woff, long value) {
            this.write(woff, (int)(value >>> 56));
            this.write(woff + 1, (int)(value >>> 48 & 0xFFL));
            this.write(woff + 2, (int)(value >>> 40 & 0xFFL));
            this.write(woff + 3, (int)(value >>> 32 & 0xFFL));
            this.write(woff + 4, (int)(value >>> 24 & 0xFFL));
            this.write(woff + 5, (int)(value >>> 16 & 0xFFL));
            this.write(woff + 6, (int)(value >>> 8 & 0xFFL));
            this.write(woff + 7, (int)(value & 0xFFL));
            return this.buf;
        }

        @Override
        public double readDouble() {
            return Double.longBitsToDouble(this.readLong());
        }

        @Override
        public double getDouble(int roff) {
            return Double.longBitsToDouble(this.getLong(roff));
        }

        @Override
        public Buffer writeDouble(double value) {
            return this.writeLong(Double.doubleToRawLongBits(value));
        }

        @Override
        public Buffer setDouble(int woff, double value) {
            return this.setLong(woff, Double.doubleToRawLongBits(value));
        }

        private long read() {
            return this.buf.readPassThrough();
        }

        private void write(int value) {
            this.buf.writePassThrough(value);
        }

        private long read(int roff) {
            return this.buf.getPassThrough(roff);
        }

        private void write(int woff, int value) {
            this.buf.setPassThrough(woff, value);
        }
    }

    @FunctionalInterface
    private static interface CopyInto {
        public void copyInto(int var1, Buffer var2, int var3, int var4);
    }

    private static final class Collector {
        private Buffer[] array;
        private int index;

        Collector(Iterable<Buffer> externals) {
            int size = 0;
            for (Buffer buf : externals) {
                size += buf.countComponents();
            }
            this.array = new Buffer[size];
        }

        void add(Buffer buffer) {
            if (this.index == this.array.length) {
                this.array = Arrays.copyOf(this.array, this.array.length * 2);
            }
            this.array[this.index] = buffer;
            ++this.index;
        }

        void collect(Iterable<Buffer> externals) {
            for (Buffer buf : externals) {
                if (buf.capacity() == 0) {
                    buf.close();
                    continue;
                }
                if (CompositeBuffer.isComposite(buf)) {
                    CompositeBuffer cbuf = (CompositeBuffer)buf;
                    this.collect(Arrays.asList(cbuf.decomposeBuffer()));
                    continue;
                }
                this.add(buf);
            }
        }

        Buffer[] toArray() {
            int i;
            int firstReadable = -1;
            int lastReadable = -1;
            for (i = 0; i < this.index; ++i) {
                if (this.array[i].readableBytes() == 0) continue;
                if (firstReadable == -1) {
                    firstReadable = i;
                }
                lastReadable = i;
            }
            if (firstReadable != -1) {
                Buffer buf;
                for (i = firstReadable + 1; i < lastReadable; ++i) {
                    buf = this.array[i];
                    if (buf.readableBytes() != 0) continue;
                    buf.close();
                    if (i <= this.index - 2) {
                        System.arraycopy(this.array, i + 1, this.array, i, this.index - i - 1);
                    }
                    --i;
                    --this.index;
                    --lastReadable;
                }
                for (i = firstReadable + 1; i < this.index; ++i) {
                    buf = this.array[i];
                    if (buf.readerOffset() <= 0) continue;
                    buf.readSplit(0).close();
                }
                for (i = 0; i < lastReadable; ++i) {
                    buf = this.array[i];
                    if (buf.writerOffset() <= 0 || buf.writerOffset() >= buf.capacity()) continue;
                    this.array[i] = buf.split();
                    buf.close();
                }
            }
            return this.array.length == this.index ? this.array : Arrays.copyOf(this.array, this.index);
        }
    }
}

