/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer;

import io.netty5.buffer.AllocationType;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.SystemPropertyUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.Locale;
import java.util.function.Supplier;

public final class DefaultBufferAllocators {
    private static final InternalLogger logger;
    private static final BufferAllocator DEFAULT_PREFERRED_ALLOCATOR;
    private static final BufferAllocator DEFAULT_ON_HEAP_ALLOCATOR;
    private static final BufferAllocator DEFAULT_OFF_HEAP_ALLOCATOR;

    private DefaultBufferAllocators() {
    }

    public static BufferAllocator preferredAllocator() {
        return DEFAULT_PREFERRED_ALLOCATOR;
    }

    public static BufferAllocator onHeapAllocator() {
        return DEFAULT_ON_HEAP_ALLOCATOR;
    }

    public static BufferAllocator offHeapAllocator() {
        return DEFAULT_OFF_HEAP_ALLOCATOR;
    }

    static {
        BufferAllocator offHeap;
        BufferAllocator onHeap;
        logger = InternalLoggerFactory.getInstance(DefaultBufferAllocators.class);
        String allocType = SystemPropertyUtil.get((String)"io.netty5.allocator.type", (String)(PlatformDependent.isAndroid() ? "unpooled" : "pooled"));
        allocType = allocType.toLowerCase(Locale.US).trim();
        boolean directBufferPreferred = PlatformDependent.directBufferPreferred();
        if ("unpooled".equals(allocType)) {
            onHeap = BufferAllocator.onHeapUnpooled();
            offHeap = BufferAllocator.offHeapUnpooled();
            logger.debug("-Dio.netty5.allocator.type: {}", (Object)allocType);
        } else if ("pooled".equals(allocType)) {
            onHeap = BufferAllocator.onHeapPooled();
            offHeap = BufferAllocator.offHeapPooled();
            logger.debug("-Dio.netty5.allocator.type: {}", (Object)allocType);
        } else {
            onHeap = BufferAllocator.onHeapPooled();
            offHeap = BufferAllocator.offHeapPooled();
            logger.debug("-Dio.netty5.allocator.type: pooled (unknown: {})", (Object)allocType);
        }
        UncloseableBufferAllocator onHeapUnclosable = new UncloseableBufferAllocator(onHeap);
        UncloseableBufferAllocator offHeapUnclosable = new UncloseableBufferAllocator(offHeap);
        DEFAULT_PREFERRED_ALLOCATOR = directBufferPreferred ? offHeapUnclosable : onHeapUnclosable;
        DEFAULT_ON_HEAP_ALLOCATOR = onHeapUnclosable;
        DEFAULT_OFF_HEAP_ALLOCATOR = offHeapUnclosable;
    }

    private static final class UncloseableBufferAllocator
    implements BufferAllocator {
        private final BufferAllocator delegate;

        UncloseableBufferAllocator(BufferAllocator delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isPooling() {
            return this.delegate.isPooling();
        }

        @Override
        public AllocationType getAllocationType() {
            return this.delegate.getAllocationType();
        }

        @Override
        public Buffer allocate(int size) {
            return this.delegate.allocate(size);
        }

        @Override
        public Supplier<Buffer> constBufferSupplier(byte[] bytes) {
            return this.delegate.constBufferSupplier(bytes);
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException("Global default buffer allocator can not be closed explicitly.");
        }
    }
}

