/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer;

import io.netty5.buffer.AllocationType;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.buffer.CompositeBuffer;
import io.netty5.buffer.DefaultCompositeBuffer;
import io.netty5.buffer.ManagedBufferAllocator;
import io.netty5.buffer.MemoryManager;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.buffer.pool.PooledBufferAllocator;
import io.netty5.util.SafeCloseable;
import io.netty5.util.Send;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.function.Supplier;

public interface BufferAllocator
extends SafeCloseable {
    public static BufferAllocator onHeapUnpooled() {
        return new ManagedBufferAllocator(MemoryManager.instance(), false);
    }

    public static BufferAllocator offHeapUnpooled() {
        return new ManagedBufferAllocator(MemoryManager.instance(), true);
    }

    public static BufferAllocator onHeapPooled() {
        return new PooledBufferAllocator(MemoryManager.instance(), false);
    }

    public static BufferAllocator offHeapPooled() {
        return new PooledBufferAllocator(MemoryManager.instance(), true);
    }

    public boolean isPooling();

    public AllocationType getAllocationType();

    public Buffer allocate(int var1);

    default public CompositeBuffer compose(Send<Buffer> send) {
        return DefaultCompositeBuffer.compose(this, Collections.singleton(send));
    }

    default public CompositeBuffer compose(Iterable<Send<Buffer>> sends) {
        return DefaultCompositeBuffer.compose(this, sends);
    }

    default public CompositeBuffer compose() {
        return DefaultCompositeBuffer.compose(this);
    }

    public Supplier<Buffer> constBufferSupplier(byte[] var1);

    default public Buffer copyOf(byte[] bytes) {
        return this.allocate(bytes.length).writeBytes(bytes);
    }

    default public Buffer copyOf(String str, Charset charset) {
        byte[] bytes = str.getBytes(charset);
        return this.allocate(bytes.length).writeBytes(bytes);
    }

    default public Buffer copyOf(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return this.allocate(0);
        }
        int bytesToCopy = buffer.remaining();
        Buffer copy = this.allocate(bytesToCopy);
        ByteBuffer duplicate = buffer.duplicate();
        try (ComponentIterator iteration = copy.forEachComponent();){
            BufferComponent c = (BufferComponent)iteration.firstWritable();
            while (c != null) {
                ByteBuffer dest = c.writableBuffer();
                int length = Math.min(dest.capacity(), duplicate.remaining());
                InternalBufferUtils.bbput(dest, 0, duplicate, duplicate.position(), length);
                duplicate.position(length + duplicate.position());
                c = (BufferComponent)((ComponentIterator.Next)((Object)c)).nextWritable();
            }
        }
        copy.skipWritableBytes(bytesToCopy);
        return copy;
    }

    public void close();
}

