/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.netty.handler.traffic.ChannelTrafficShapingHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.netty.handler.traffic.TrafficCounter;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;

public class TrafficShapingHandlerTest
extends AbstractSocketTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(TrafficShapingHandlerTest.class);
    private static final InternalLogger loggerServer = InternalLoggerFactory.getInstance((String)"ServerTSH");
    private static final InternalLogger loggerClient = InternalLoggerFactory.getInstance((String)"ClientTSH");
    static final int messageSize = 1024;
    static final int bandwidthFactor = 12;
    static final int minfactor = 3;
    static final int maxfactor = 18;
    static final long stepms = 70L;
    static final long minimalms = Math.max(35L, 20L) / 10L * 10L;
    static final long check = 10L;
    private static final Random random = new Random();
    static final byte[] data = new byte[1024];
    private static final String TRAFFIC = "traffic";
    private static String currentTestName;
    private static int currentTestRun;
    private static EventExecutorGroup group;
    private static EventExecutorGroup groupForGlobal;
    private static final ScheduledExecutorService executor;

    @BeforeAll
    public static void createGroup() {
        logger.info("Bandwidth: 3 <= 12 <= 18 StepMs: 70 MinMs: " + minimalms + " CheckMs: " + 10L);
        group = new DefaultEventExecutorGroup(8);
        groupForGlobal = new DefaultEventExecutorGroup(8);
    }

    @AfterAll
    public static void destroyGroup() throws Exception {
        group.shutdownGracefully().sync();
        groupForGlobal.shutdownGracefully().sync();
        executor.shutdown();
    }

    private static long[] computeWaitRead(int[] multipleMessage) {
        long[] minimalWaitBetween = new long[multipleMessage.length + 1];
        minimalWaitBetween[0] = 0L;
        for (int i = 0; i < multipleMessage.length; ++i) {
            minimalWaitBetween[i + 1] = multipleMessage[i] > 1 ? (long)(multipleMessage[i] - 1) * 70L + minimalms : 10L;
        }
        return minimalWaitBetween;
    }

    private static long[] computeWaitWrite(int[] multipleMessage) {
        long[] minimalWaitBetween = new long[multipleMessage.length + 1];
        for (int i = 0; i < multipleMessage.length; ++i) {
            minimalWaitBetween[i] = multipleMessage[i] > 1 ? (long)(multipleMessage[i] - 1) * 70L + minimalms : 10L;
        }
        return minimalWaitBetween;
    }

    private static long[] computeWaitAutoRead(int[] autoRead) {
        long[] minimalWaitBetween = new long[autoRead.length + 1];
        minimalWaitBetween[0] = 0L;
        for (int i = 0; i < autoRead.length; ++i) {
            if (autoRead[i] != 0) {
                if (autoRead[i] > 0) {
                    minimalWaitBetween[i + 1] = -1L;
                    continue;
                }
                minimalWaitBetween[i + 1] = 10L;
                continue;
            }
            minimalWaitBetween[i + 1] = 0L;
        }
        return minimalWaitBetween;
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testNoTrafficShapping(TestInfo testInfo) throws Throwable {
        currentTestName = "TEST NO TRAFFIC";
        currentTestRun = 0;
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                TrafficShapingHandlerTest.this.testNoTrafficShapping(serverBootstrap, bootstrap);
            }
        });
    }

    public void testNoTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 2, 1};
        long[] minimalWaitBetween = null;
        TrafficShapingHandlerTest.testTrafficShapping0(sb, cb, false, false, false, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testWriteTrafficShapping(TestInfo testInfo) throws Throwable {
        currentTestName = "TEST WRITE";
        currentTestRun = 0;
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                TrafficShapingHandlerTest.this.testWriteTrafficShapping(serverBootstrap, bootstrap);
            }
        });
    }

    public void testWriteTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 2, 1, 1};
        long[] minimalWaitBetween = TrafficShapingHandlerTest.computeWaitWrite(multipleMessage);
        TrafficShapingHandlerTest.testTrafficShapping0(sb, cb, false, false, true, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testReadTrafficShapping(TestInfo testInfo) throws Throwable {
        currentTestName = "TEST READ";
        currentTestRun = 0;
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                TrafficShapingHandlerTest.this.testReadTrafficShapping(serverBootstrap, bootstrap);
            }
        });
    }

    public void testReadTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 2, 1, 1};
        long[] minimalWaitBetween = TrafficShapingHandlerTest.computeWaitRead(multipleMessage);
        TrafficShapingHandlerTest.testTrafficShapping0(sb, cb, false, true, false, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testWrite1TrafficShapping(TestInfo testInfo) throws Throwable {
        currentTestName = "TEST WRITE";
        currentTestRun = 0;
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                TrafficShapingHandlerTest.this.testWrite1TrafficShapping(serverBootstrap, bootstrap);
            }
        });
    }

    public void testWrite1TrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 1, 1};
        long[] minimalWaitBetween = TrafficShapingHandlerTest.computeWaitWrite(multipleMessage);
        TrafficShapingHandlerTest.testTrafficShapping0(sb, cb, false, false, true, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testRead1TrafficShapping(TestInfo testInfo) throws Throwable {
        currentTestName = "TEST READ";
        currentTestRun = 0;
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                TrafficShapingHandlerTest.this.testRead1TrafficShapping(serverBootstrap, bootstrap);
            }
        });
    }

    public void testRead1TrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 1, 1};
        long[] minimalWaitBetween = TrafficShapingHandlerTest.computeWaitRead(multipleMessage);
        TrafficShapingHandlerTest.testTrafficShapping0(sb, cb, false, true, false, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testWriteGlobalTrafficShapping(TestInfo testInfo) throws Throwable {
        currentTestName = "TEST GLOBAL WRITE";
        currentTestRun = 0;
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                TrafficShapingHandlerTest.this.testWriteGlobalTrafficShapping(serverBootstrap, bootstrap);
            }
        });
    }

    public void testWriteGlobalTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 2, 1, 1};
        long[] minimalWaitBetween = TrafficShapingHandlerTest.computeWaitWrite(multipleMessage);
        TrafficShapingHandlerTest.testTrafficShapping0(sb, cb, false, false, true, true, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testReadGlobalTrafficShapping(TestInfo testInfo) throws Throwable {
        currentTestName = "TEST GLOBAL READ";
        currentTestRun = 0;
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                TrafficShapingHandlerTest.this.testReadGlobalTrafficShapping(serverBootstrap, bootstrap);
            }
        });
    }

    public void testReadGlobalTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 2, 1, 1};
        long[] minimalWaitBetween = TrafficShapingHandlerTest.computeWaitRead(multipleMessage);
        TrafficShapingHandlerTest.testTrafficShapping0(sb, cb, false, true, false, true, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testAutoReadTrafficShapping(TestInfo testInfo) throws Throwable {
        currentTestName = "TEST AUTO READ";
        currentTestRun = 0;
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                TrafficShapingHandlerTest.this.testAutoReadTrafficShapping(serverBootstrap, bootstrap);
            }
        });
    }

    public void testAutoReadTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = new int[]{1, -1, -1, 1, -2, 0, 1, 0, -3, 0, 1, 2, 0};
        int[] multipleMessage = new int[autoRead.length];
        Arrays.fill(multipleMessage, 1);
        long[] minimalWaitBetween = TrafficShapingHandlerTest.computeWaitAutoRead(autoRead);
        TrafficShapingHandlerTest.testTrafficShapping0(sb, cb, false, true, false, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testAutoReadGlobalTrafficShapping(TestInfo testInfo) throws Throwable {
        currentTestName = "TEST AUTO READ GLOBAL";
        currentTestRun = 0;
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                TrafficShapingHandlerTest.this.testAutoReadGlobalTrafficShapping(serverBootstrap, bootstrap);
            }
        });
    }

    public void testAutoReadGlobalTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = new int[]{1, -1, -1, 1, -2, 0, 1, 0, -3, 0, 1, 2, 0};
        int[] multipleMessage = new int[autoRead.length];
        Arrays.fill(multipleMessage, 1);
        long[] minimalWaitBetween = TrafficShapingHandlerTest.computeWaitAutoRead(autoRead);
        TrafficShapingHandlerTest.testTrafficShapping0(sb, cb, false, true, false, true, autoRead, minimalWaitBetween, multipleMessage);
    }

    private static void testTrafficShapping0(ServerBootstrap sb, Bootstrap cb, boolean additionalExecutor, final boolean limitRead, final boolean limitWrite, boolean globalLimit, int[] autoRead, long[] minimalWaitBetween, int[] multipleMessage) throws Throwable {
        logger.info("TEST: " + currentTestName + " RUN: " + ++currentTestRun + " Exec: " + additionalExecutor + " Read: " + limitRead + " Write: " + limitWrite + " Global: " + globalLimit);
        ServerHandler sh = new ServerHandler(autoRead, multipleMessage);
        Promise promise = group.next().newPromise();
        ClientHandler ch = new ClientHandler((Promise<Boolean>)promise, minimalWaitBetween, multipleMessage, autoRead);
        Object handler = limitRead ? (globalLimit ? new GlobalTrafficShapingHandler((ScheduledExecutorService)groupForGlobal, 0L, 12288L, 10L) : new ChannelTrafficShapingHandler(0L, 12288L, 10L)) : (limitWrite ? (globalLimit ? new GlobalTrafficShapingHandler((ScheduledExecutorService)groupForGlobal, 12288L, 0L, 10L) : new ChannelTrafficShapingHandler(12288L, 0L, 10L)) : null);
        sb.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>((AbstractTrafficShapingHandler)handler, sh){
            final /* synthetic */ AbstractTrafficShapingHandler val$handler;
            final /* synthetic */ ServerHandler val$sh;
            {
                this.val$handler = abstractTrafficShapingHandler;
                this.val$sh = serverHandler;
            }

            protected void initChannel(SocketChannel c) throws Exception {
                if (limitRead) {
                    c.pipeline().addLast(TrafficShapingHandlerTest.TRAFFIC, (ChannelHandler)this.val$handler);
                }
                c.pipeline().addLast(new ChannelHandler[]{this.val$sh});
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<SocketChannel>((AbstractTrafficShapingHandler)handler, ch){
            final /* synthetic */ AbstractTrafficShapingHandler val$handler;
            final /* synthetic */ ClientHandler val$ch;
            {
                this.val$handler = abstractTrafficShapingHandler;
                this.val$ch = clientHandler;
            }

            protected void initChannel(SocketChannel c) throws Exception {
                if (limitWrite) {
                    c.pipeline().addLast(TrafficShapingHandlerTest.TRAFFIC, (ChannelHandler)this.val$handler);
                }
                c.pipeline().addLast(new ChannelHandler[]{this.val$ch});
            }
        });
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect(sc.localAddress()).sync().channel();
        int totalNb = 0;
        for (int i = 1; i < multipleMessage.length; ++i) {
            totalNb += multipleMessage[i];
        }
        Long start = TrafficCounter.milliSecondFromNano();
        int nb = multipleMessage[0];
        for (int i = 0; i < nb; ++i) {
            cc.write((Object)cc.alloc().buffer().writeBytes(data));
        }
        cc.flush();
        promise.await();
        Long stop = TrafficCounter.milliSecondFromNano();
        Assertions.assertTrue((boolean)promise.isSuccess(), (String)("Error during execution of TrafficShapping: " + promise.cause()));
        float average = (float)(totalNb * 1024) / (float)(stop - start);
        logger.info("TEST: " + currentTestName + " RUN: " + currentTestRun + " Average of traffic: " + average + " compare to " + 12);
        sh.channel.close().sync();
        ch.channel.close().sync();
        sc.close().sync();
        if (autoRead != null) {
            Thread.sleep(minimalms);
        }
        if (autoRead == null && minimalWaitBetween != null) {
            Assertions.assertTrue((average <= 18.0f ? 1 : 0) != 0, (String)("Overall Traffic not ok since > 18: " + average));
            if (additionalExecutor) {
                Assertions.assertTrue(((double)average >= 0.25 ? 1 : 0) != 0, (String)("Overall Traffic not ok since < 0.25: " + average));
            } else {
                Assertions.assertTrue((average >= 3.0f ? 1 : 0) != 0, (String)("Overall Traffic not ok since < 3: " + average));
            }
        }
        if (handler != null && globalLimit) {
            ((GlobalTrafficShapingHandler)handler).release();
        }
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    static {
        executor = Executors.newScheduledThreadPool(10);
        random.nextBytes(data);
    }

    private static class ServerHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final int[] autoRead;
        private final int[] multipleMessage;
        volatile Channel channel;
        volatile int step;
        final AtomicReference<Throwable> exception = new AtomicReference();

        ServerHandler(int[] autoRead, int[] multipleMessage) {
            this.autoRead = autoRead;
            this.multipleMessage = Arrays.copyOf(multipleMessage, multipleMessage.length);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            int i;
            byte[] actual = new byte[in.readableBytes()];
            int nb = actual.length / 1024;
            loggerServer.info("Step: " + this.step + " Read: " + nb + " blocks");
            in.readBytes(actual);
            long timestamp = TrafficCounter.milliSecondFromNano();
            int isAutoRead = 0;
            int laststep = this.step;
            for (i = 0; i < nb; ++i) {
                int n = this.step;
                this.multipleMessage[n] = this.multipleMessage[n] - 1;
                if (this.multipleMessage[this.step] != 0) continue;
                if (this.autoRead != null) {
                    isAutoRead = this.autoRead[this.step];
                }
                ++this.step;
            }
            if (laststep != this.step && this.autoRead != null && isAutoRead != 2) {
                if (isAutoRead != 0) {
                    loggerServer.info("Step: " + this.step + " Set AutoRead: " + (isAutoRead > 0));
                    this.channel.config().setAutoRead(isAutoRead > 0);
                } else {
                    loggerServer.info("Step: " + this.step + " AutoRead: NO");
                }
            }
            Thread.sleep(10L);
            loggerServer.debug("Step: " + this.step + " Write: " + nb);
            for (i = 0; i < nb; ++i) {
                this.channel.write((Object)Unpooled.copyLong((long)timestamp));
            }
            this.channel.flush();
            if (laststep != this.step && isAutoRead != 0) {
                int exactStep;
                if (isAutoRead < 0) {
                    long wait;
                    exactStep = this.step;
                    long l = wait = isAutoRead == -1 ? minimalms : 70L + minimalms;
                    if (isAutoRead == -3) {
                        wait = 210L;
                    }
                    executor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            loggerServer.info("Step: " + exactStep + " Reset AutoRead");
                            channel.config().setAutoRead(true);
                        }
                    }, wait, TimeUnit.MILLISECONDS);
                } else if (isAutoRead > 1) {
                    loggerServer.debug("Step: " + this.step + " Will Set AutoRead: True");
                    exactStep = this.step;
                    executor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            loggerServer.info("Step: " + exactStep + " Set AutoRead: True");
                            channel.config().setAutoRead(true);
                        }
                    }, 70L + minimalms, TimeUnit.MILLISECONDS);
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                cause.printStackTrace();
                ctx.close();
            }
        }
    }

    private static class ClientHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();
        volatile int step;
        private long currentLastTime = TrafficCounter.milliSecondFromNano();
        private final long[] minimalWaitBetween;
        private final int[] multipleMessage;
        private final int[] autoRead;
        final Promise<Boolean> promise;

        ClientHandler(Promise<Boolean> promise, long[] minimalWaitBetween, int[] multipleMessage, int[] autoRead) {
            this.minimalWaitBetween = minimalWaitBetween;
            this.multipleMessage = Arrays.copyOf(multipleMessage, multipleMessage.length);
            this.promise = promise;
            this.autoRead = autoRead;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            long lastTimestamp = 0L;
            loggerClient.debug("Step: " + this.step + " Read: " + in.readableBytes() / 8 + " blocks");
            while (in.isReadable()) {
                lastTimestamp = in.readLong();
                int n = this.step;
                this.multipleMessage[n] = this.multipleMessage[n] - 1;
            }
            if (this.multipleMessage[this.step] > 0) {
                return;
            }
            long minimalWait = this.minimalWaitBetween != null ? this.minimalWaitBetween[this.step] : 0L;
            int ar = 0;
            if (this.autoRead != null && this.step > 0 && this.autoRead[this.step - 1] != 0) {
                ar = this.autoRead[this.step - 1];
            }
            loggerClient.info("Step: " + this.step + " Interval: " + (lastTimestamp - this.currentLastTime) + " compareTo " + minimalWait + " (" + ar + ')');
            Assertions.assertTrue((lastTimestamp - this.currentLastTime >= minimalWait ? 1 : 0) != 0, (String)("The interval of time is incorrect:" + (lastTimestamp - this.currentLastTime) + " not> " + minimalWait));
            this.currentLastTime = lastTimestamp;
            ++this.step;
            if (this.multipleMessage.length > this.step) {
                int nb = this.multipleMessage[this.step];
                for (int i = 0; i < nb; ++i) {
                    this.channel.write((Object)this.channel.alloc().buffer().writeBytes(data));
                }
                this.channel.flush();
            } else {
                this.promise.setSuccess((Object)true);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                cause.printStackTrace();
                this.promise.setFailure(cause);
                ctx.close();
            }
        }
    }
}

