/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.SocketProtocolFamily;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.SocketTestPermutation;
import io.netty.util.NetUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;

public abstract class AbstractDatagramTest
extends AbstractComboTestsuiteTest<Bootstrap, Bootstrap> {
    @Override
    protected List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> newFactories() {
        return SocketTestPermutation.INSTANCE.datagram(this.socketInternetProtocalFamily());
    }

    @Override
    protected void configure(Bootstrap bootstrap, Bootstrap bootstrap2, ByteBufAllocator allocator) {
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)allocator);
        bootstrap2.option(ChannelOption.ALLOCATOR, (Object)allocator);
    }

    protected SocketAddress newSocketAddress() {
        switch (this.socketInternetProtocalFamily()) {
            case INET: {
                return new InetSocketAddress(NetUtil.LOCALHOST4, 0);
            }
            case INET6: {
                return new InetSocketAddress(NetUtil.LOCALHOST6, 0);
            }
        }
        throw new AssertionError();
    }

    protected boolean isSupported(SocketProtocolFamily family, InetAddress address) {
        switch (family) {
            case INET: {
                return address instanceof Inet4Address;
            }
            case INET6: {
                return address instanceof Inet6Address;
            }
        }
        return false;
    }

    protected SocketProtocolFamily socketProtocolFamily() {
        return SocketProtocolFamily.INET;
    }

    protected SocketProtocolFamily groupInternetProtocalFamily() {
        return this.socketProtocolFamily();
    }

    protected SocketProtocolFamily socketInternetProtocalFamily() {
        return this.socketProtocolFamily();
    }
}

