/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport;

import io.netty.channel.Channel;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.testsuite.transport.AbstractSingleThreadEventLoopTest;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;

public class DefaultEventLoopTest
extends AbstractSingleThreadEventLoopTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelsIteratorNotSupported() throws Exception {
        EventLoopGroup group = this.newEventLoopGroup();
        final SingleThreadEventLoop loop = (SingleThreadEventLoop)group.next();
        try {
            Channel ch = this.newChannel();
            loop.register(ch).syncUninterruptibly();
            Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    loop.registeredChannelsIterator();
                }
            });
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Override
    protected EventLoopGroup newEventLoopGroup() {
        return new DefaultEventLoopGroup();
    }

    @Override
    protected EventLoopGroup newAutoScalingEventLoopGroup() {
        return new AutoScalingDefaultEventLoopGroup(2, AUTO_SCALING_CHOOSER_FACTORY);
    }

    @Override
    protected Channel newChannel() {
        return new LocalChannel();
    }

    @Override
    protected Class<? extends ServerChannel> serverChannelClass() {
        return LocalServerChannel.class;
    }

    private static final class AutoScalingDefaultEventLoopGroup
    extends MultithreadEventLoopGroup {
        AutoScalingDefaultEventLoopGroup(int nThreads, EventExecutorChooserFactory chooserFactory) {
            super(nThreads, (Executor)null, chooserFactory, new Object[0]);
        }

        protected EventLoop newChild(Executor executor, Object ... args) throws Exception {
            return new SuspendableDefaultEventLoop((EventLoopGroup)this, executor);
        }
    }

    private static final class SuspendableDefaultEventLoop
    extends SingleThreadEventLoop {
        SuspendableDefaultEventLoop(EventLoopGroup parent, Executor executor) {
            super(parent, executor, true, true, DEFAULT_MAX_PENDING_TASKS, RejectedExecutionHandlers.reject());
        }

        protected void run() {
            do {
                Runnable task;
                if ((task = this.takeTask()) == null) continue;
                SuspendableDefaultEventLoop.runTask((Runnable)task);
                this.updateLastExecutionTime();
            } while (!this.canSuspend() && !this.confirmShutdown());
        }
    }
}

