/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.testsuite.transport.AbstractTestsuiteTest;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.AbstractClientSocketTest;
import io.netty.testsuite.transport.socket.SocketTestPermutation;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.net.PortUnreachableException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;

public class DatagramConnectNotExistsTest
extends AbstractClientSocketTest {
    @Override
    protected List<TestsuitePermutation.BootstrapFactory<Bootstrap>> newFactories() {
        return SocketTestPermutation.INSTANCE.datagramSocket();
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testConnectNotExists(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractTestsuiteTest.Runner<Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap) {
                DatagramConnectNotExistsTest.this.testConnectNotExists(bootstrap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectNotExists(Bootstrap cb) {
        Assumptions.assumeFalse((boolean)PlatformDependent.isWindows());
        final Promise promise = ImmediateEventExecutor.INSTANCE.newPromise();
        cb.handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                promise.trySuccess((Object)cause);
            }
        });
        ChannelFuture future = cb.connect(NetUtil.LOCALHOST, SocketTestPermutation.BAD_PORT);
        try {
            Channel datagramChannel = future.syncUninterruptibly().channel();
            Assertions.assertTrue((boolean)datagramChannel.isActive());
            datagramChannel.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII)).syncUninterruptibly();
            if (!(datagramChannel instanceof OioDatagramChannel)) {
                Assertions.assertTrue((boolean)(promise.syncUninterruptibly().getNow() instanceof PortUnreachableException));
            }
        }
        finally {
            future.channel().close();
        }
    }
}

