/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.testsuite.util.TestUtils;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;

public class SocketGatheringWriteTest
extends AbstractSocketTest {
    private static final long TIMEOUT = 120000L;
    private static final Random random = new Random();
    static final byte[] data = new byte[0x100000];

    @AfterAll
    public static void compressHeapDumps() throws Exception {
        TestUtils.compressHeapDumps();
    }

    @Test
    @Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
    public void testGatheringWrite(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketGatheringWriteTest.this.testGatheringWrite(serverBootstrap, bootstrap);
            }
        });
    }

    public void testGatheringWrite(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.testGatheringWrite0(sb, cb, data, false, true);
    }

    @Test
    @Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
    public void testGatheringWriteNotAutoRead(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketGatheringWriteTest.this.testGatheringWriteNotAutoRead(serverBootstrap, bootstrap);
            }
        });
    }

    public void testGatheringWriteNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.testGatheringWrite0(sb, cb, data, false, false);
    }

    @Test
    @Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
    public void testGatheringWriteWithComposite(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketGatheringWriteTest.this.testGatheringWriteWithComposite(serverBootstrap, bootstrap);
            }
        });
    }

    public void testGatheringWriteWithComposite(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.testGatheringWrite0(sb, cb, data, true, true);
    }

    @Test
    @Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
    public void testGatheringWriteWithCompositeNotAutoRead(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketGatheringWriteTest.this.testGatheringWriteWithCompositeNotAutoRead(serverBootstrap, bootstrap);
            }
        });
    }

    public void testGatheringWriteWithCompositeNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.testGatheringWrite0(sb, cb, data, true, false);
    }

    @Test
    @Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
    public void testGatheringWriteBig(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketGatheringWriteTest.this.testGatheringWriteBig(serverBootstrap, bootstrap);
            }
        });
    }

    public void testGatheringWriteBig(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        byte[] bigData = new byte[0x3200000];
        random.nextBytes(bigData);
        this.testGatheringWrite0(sb, cb, bigData, false, true);
    }

    private void testGatheringWrite0(ServerBootstrap sb, Bootstrap cb, byte[] data, boolean composite, boolean autoRead) throws Throwable {
        int length;
        sb.childOption(ChannelOption.AUTO_READ, (Object)autoRead);
        cb.option(ChannelOption.AUTO_READ, (Object)autoRead);
        Promise serverDonePromise = ImmediateEventExecutor.INSTANCE.newPromise();
        TestServerHandler sh = new TestServerHandler(autoRead, (Promise<Void>)serverDonePromise, data.length);
        TestHandler ch = new TestHandler(autoRead);
        cb.handler((ChannelHandler)ch);
        sb.childHandler((ChannelHandler)sh);
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect(sc.localAddress()).sync().channel();
        for (int i = 0; i < data.length; i += length) {
            length = Math.min(random.nextInt(8192), data.length - i);
            if (composite && i % 2 == 0) {
                int firstBufLength = length / 2;
                CompositeByteBuf comp = Unpooled.compositeBuffer();
                comp.addComponent(true, TestsuitePermutation.randomBufferType(cc.alloc(), data, i, firstBufLength)).addComponent(true, TestsuitePermutation.randomBufferType(cc.alloc(), data, i + firstBufLength, length - firstBufLength));
                cc.write((Object)comp);
                continue;
            }
            cc.write((Object)TestsuitePermutation.randomBufferType(cc.alloc(), data, i, length));
        }
        ChannelFuture cf = cc.writeAndFlush((Object)Unpooled.EMPTY_BUFFER);
        Assertions.assertNotEquals((Object)cc.voidPromise(), (Object)cf);
        try {
            Assertions.assertTrue((boolean)cf.await(60000L));
            cf.sync();
        }
        catch (Throwable t) {
            TestUtils.dump(StringUtil.simpleClassName((Object)this));
            throw t;
        }
        serverDonePromise.sync();
        sh.channel.close().sync();
        ch.channel.close().sync();
        sc.close().sync();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw (Throwable)sh.exception.get();
        }
        if (sh.exception.get() != null) {
            throw (Throwable)sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])data);
        Assertions.assertEquals((Object)expected, (Object)sh.received);
        expected.release();
        sh.received.release();
    }

    static {
        random.nextBytes(data);
    }

    private static class TestHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final boolean autoRead;
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();

        TestHandler(boolean autoRead) {
            this.autoRead = autoRead;
        }

        public final void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
            if (!this.autoRead) {
                ctx.read();
            }
            super.channelActive(ctx);
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        }

        public final void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            if (!this.autoRead) {
                ctx.read();
            }
            super.channelReadComplete(ctx);
        }

        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                this.handleException(ctx, cause);
            }
            super.exceptionCaught(ctx, cause);
        }

        void handleException(ChannelHandlerContext ctx, Throwable cause) {
            ctx.close();
        }
    }

    private static final class TestServerHandler
    extends TestHandler {
        private final int expectedBytes;
        private final Promise<Void> doneReadingPromise;
        final ByteBuf received = Unpooled.buffer();

        TestServerHandler(boolean autoRead, Promise<Void> doneReadingPromise, int expectedBytes) {
            super(autoRead);
            this.doneReadingPromise = doneReadingPromise;
            this.expectedBytes = expectedBytes;
        }

        @Override
        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            this.received.writeBytes(in);
            if (this.received.readableBytes() >= this.expectedBytes) {
                this.doneReadingPromise.setSuccess(null);
            }
        }

        @Override
        void handleException(ChannelHandlerContext ctx, Throwable cause) {
            this.doneReadingPromise.tryFailure(cause);
            super.handleException(ctx, cause);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.doneReadingPromise.tryFailure((Throwable)new IllegalStateException("server closed!"));
            super.channelInactive(ctx);
        }
    }
}

