/*
 * Decompiled with CFR 0.152.
 */
package io.netty.pkitesting;

import com.sun.net.httpserver.HttpServer;
import io.netty.pkitesting.CertificateList;
import io.netty.pkitesting.Signed;
import io.netty.pkitesting.X509Bundle;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;

public final class RevocationServer {
    private static volatile RevocationServer instance;
    private final HttpServer crlServer = HttpServer.create(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0), 0);
    private final String crlBaseAddress = "http://localhost:" + this.crlServer.getAddress().getPort();
    private final AtomicInteger issuerCounter = new AtomicInteger();
    private final ConcurrentMap<X509Certificate, CrlInfo> issuers = new ConcurrentHashMap<X509Certificate, CrlInfo>();
    private final ConcurrentMap<String, CrlInfo> paths = new ConcurrentHashMap<String, CrlInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RevocationServer getInstance() throws Exception {
        if (instance != null) {
            return instance;
        }
        Class<RevocationServer> clazz = RevocationServer.class;
        synchronized (RevocationServer.class) {
            RevocationServer server = instance;
            if (server == null) {
                server = new RevocationServer();
                server.start();
                instance = server;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return server;
        }
    }

    private RevocationServer() throws Exception {
        this.crlServer.createContext("/", exchange -> {
            if ("GET".equals(exchange.getRequestMethod())) {
                String path = exchange.getRequestURI().getPath();
                CrlInfo info = (CrlInfo)this.paths.get(path);
                if (info == null) {
                    exchange.sendResponseHeaders(404, 0L);
                    exchange.close();
                    return;
                }
                byte[] crl = RevocationServer.generateCrl(info);
                exchange.getResponseHeaders().put("Content-Type", Collections.singletonList("application/pkix-crl"));
                exchange.sendResponseHeaders(200, crl.length);
                try (OutputStream out = exchange.getResponseBody();){
                    out.write(crl);
                    out.flush();
                }
            } else {
                exchange.sendResponseHeaders(405, 0L);
            }
            exchange.close();
        });
    }

    private void start() {
        if (Thread.currentThread().isDaemon()) {
            this.crlServer.start();
        } else {
            ForkJoinPool.commonPool().execute(this.crlServer::start);
        }
    }

    public void register(X509Bundle issuer) {
        this.register(issuer, null);
    }

    public void register(X509Bundle issuer, Provider provider) {
        this.issuers.computeIfAbsent(issuer.getCertificate(), bundle -> {
            String path = "/crl/" + this.issuerCounter.incrementAndGet() + ".crl";
            URI uri = URI.create(this.crlBaseAddress + path);
            CrlInfo info = new CrlInfo(issuer, uri, provider);
            this.paths.put(path, info);
            return info;
        });
    }

    public void revoke(X509Bundle cert, Instant time) {
        X509Certificate[] certPath = cert.getCertificatePathWithRoot();
        X509Certificate issuer = certPath.length == 1 ? certPath[0] : certPath[1];
        CrlInfo info = (CrlInfo)this.issuers.get(issuer);
        if (info == null) {
            throw new IllegalArgumentException("Not a registered issuer: " + issuer.getSubjectX500Principal());
        }
        info.revokedCerts.put(cert.getCertificate().getSerialNumber(), time);
    }

    public URI getCrlUri(X509Bundle issuer) {
        CrlInfo info = (CrlInfo)this.issuers.get(issuer.getCertificate());
        if (info != null) {
            return info.uri;
        }
        return null;
    }

    private static byte[] generateCrl(CrlInfo info) {
        X509Bundle issuer = info.issuer;
        Map certs = info.revokedCerts;
        Instant now = Instant.now();
        CertificateList list = new CertificateList(issuer, now, now, certs.entrySet());
        try {
            Signed signed = new Signed(list.getEncoded(), issuer);
            return signed.getEncoded(info.provider);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to sign CRL", e);
        }
    }

    private static final class CrlInfo {
        private final X509Bundle issuer;
        private final URI uri;
        private final Map<BigInteger, Instant> revokedCerts;
        private final Provider provider;

        CrlInfo(X509Bundle issuer, URI uri, Provider provider) {
            this.issuer = issuer;
            this.uri = uri;
            this.provider = provider;
            this.revokedCerts = new ConcurrentHashMap<BigInteger, Instant>();
        }
    }
}

