/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class SimpleByteBufPooledAllocatorBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"123", "1234", "12345", "123456", "1234567"})
    public int size;
    @Param(value={"0", "5", "10", "100"})
    public long tokens;
    @Param(value={"true", "false"})
    public boolean useThreadCache;
    public ByteBufAllocator allocator;

    public SimpleByteBufPooledAllocatorBenchmark() {
        super(true, false);
    }

    @Setup(value=Level.Trial)
    public void doSetup() {
        this.allocator = new PooledByteBufAllocator(PooledByteBufAllocator.defaultPreferDirect(), PooledByteBufAllocator.defaultNumHeapArena(), PooledByteBufAllocator.defaultNumDirectArena(), PooledByteBufAllocator.defaultPageSize(), PooledByteBufAllocator.defaultMaxOrder(), PooledByteBufAllocator.defaultTinyCacheSize(), PooledByteBufAllocator.defaultSmallCacheSize(), PooledByteBufAllocator.defaultNormalCacheSize(), this.useThreadCache);
    }

    @Benchmark
    public boolean getAndRelease() {
        ByteBuf buf = this.allocator.directBuffer(this.size);
        if (this.tokens > 0L) {
            Blackhole.consumeCPU((long)this.tokens);
        }
        return buf.release();
    }
}

