/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.headers;

import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@Fork(value=2)
@Warmup(iterations=10, time=200, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=200, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class IsKeepAliveBenchmark
extends AbstractMicrobenchmark {
    @Param
    public ConnectionClose close;
    @Param(value={"false", "true"})
    public boolean warmup;
    FullHttpRequest request;

    @Setup
    public void setup(Blackhole bh) {
        this.request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/index.html");
        HttpHeaders headers = this.request.headers();
        headers.set((CharSequence)HttpHeaderNames.HOST, (Object)"localhost");
        headers.set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36");
        headers.set((CharSequence)HttpHeaderNames.ACCEPT, (Object)"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
        headers.set((CharSequence)HttpHeaderNames.ACCEPT_LANGUAGE, (Object)"en-US,en;q=0.9");
        headers.set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)"gzip, deflate");
        headers.set((CharSequence)HttpHeaderNames.UPGRADE_INSECURE_REQUESTS, (Object)"1");
        headers.set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"max-age=0");
        if (this.warmup) {
            int i;
            ConnectionClose[] cases = ConnectionClose.values();
            FullHttpRequest[] requests = new FullHttpRequest[cases.length];
            for (i = 0; i < requests.length; ++i) {
                requests[i] = this.request.copy();
                IsKeepAliveBenchmark.setConnectionClose(requests[i].headers(), cases[i]);
            }
            for (i = 0; i < 100000; ++i) {
                for (FullHttpRequest httpRequest : requests) {
                    bh.consume(IsKeepAliveBenchmark.isKeepAlive((HttpRequest)httpRequest));
                }
            }
        }
        IsKeepAliveBenchmark.setConnectionClose(headers, this.close);
    }

    private static void setConnectionClose(HttpHeaders headers, ConnectionClose close) {
        switch (close) {
            case KeepAlive: {
                headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"keep-alive");
                break;
            }
            case Close: {
                headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
                break;
            }
        }
    }

    @Benchmark
    public boolean isKeepAlive() {
        return IsKeepAliveBenchmark.isKeepAlive((HttpRequest)this.request);
    }

    @Benchmark
    @Fork(value=2, jvmArgsAppend={"-XX:-DoEscapeAnalysis"})
    public boolean isKeepAliveWithGarbage() {
        return IsKeepAliveBenchmark.isKeepAlive((HttpRequest)this.request);
    }

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public static boolean isKeepAlive(HttpRequest request) {
        return HttpUtil.isKeepAlive((HttpMessage)request);
    }

    public static enum ConnectionClose {
        KeepAlive,
        Close,
        None;

    }
}

