/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.CharsetUtil;
import io.netty.util.ResourceLeakDetector;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Threads(value=1)
@Warmup(iterations=2)
@Measurement(iterations=3)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class HttpPostMultipartRequestDecoderBenchmark
extends AbstractMicrobenchmark {
    public double testHighNumberChunks(boolean big, boolean noDisk) {
        String BOUNDARY = "01f136d9282f";
        int size = 8192;
        int chunkNumber = 64;
        StringBuilder stringBuilder = new StringBuilder(size);
        stringBuilder.setLength(size);
        String data = stringBuilder.toString();
        byte[] bodyStartBytes = ("--" + BOUNDARY + "\nContent-Disposition: form-data; name=\"msg_id\"\n\n15200\n--" + BOUNDARY + "\nContent-Disposition: form-data; name=\"msg1\"; filename=\"file1.txt\"\n\n" + data).getBytes(CharsetUtil.UTF_8);
        byte[] bodyPartBigBytes = data.getBytes(CharsetUtil.UTF_8);
        byte[] intermediaryBytes = ("\n--" + BOUNDARY + "\nContent-Disposition: form-data; name=\"msg2\"; filename=\"file2.txt\"\n\n" + data).getBytes(CharsetUtil.UTF_8);
        byte[] finalBigBytes = ("\n--" + BOUNDARY + "--\n").getBytes(CharsetUtil.UTF_8);
        ByteBuf firstBuf = Unpooled.wrappedBuffer((byte[])bodyStartBytes);
        ByteBuf finalBuf = Unpooled.wrappedBuffer((byte[])finalBigBytes);
        ByteBuf nextBuf = big ? Unpooled.wrappedBuffer((byte[])bodyPartBigBytes) : Unpooled.wrappedBuffer((byte[])intermediaryBytes);
        DefaultHttpRequest req = new DefaultHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.POST, "/up");
        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)("multipart/form-data; boundary=" + BOUNDARY));
        long start = System.nanoTime();
        DefaultHttpDataFactory defaultHttpDataFactory = new DefaultHttpDataFactory(noDisk ? 0x100000L : 16384L);
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)defaultHttpDataFactory, (HttpRequest)req);
        firstBuf.retain();
        decoder.offer((HttpContent)new DefaultHttpContent(firstBuf));
        firstBuf.release();
        for (int i = 1; i < chunkNumber; ++i) {
            nextBuf.retain();
            decoder.offer((HttpContent)new DefaultHttpContent(nextBuf));
            nextBuf.release();
            nextBuf.readerIndex(0);
        }
        finalBuf.retain();
        decoder.offer((HttpContent)new DefaultLastHttpContent(finalBuf));
        finalBuf.release();
        while (decoder.hasNext()) {
            InterfaceHttpData i = decoder.next();
        }
        while (finalBuf.refCnt() > 0) {
            finalBuf.release();
        }
        while (nextBuf.refCnt() > 0) {
            nextBuf.release();
        }
        while (finalBuf.refCnt() > 0) {
            finalBuf.release();
        }
        long stop = System.nanoTime();
        double time = (double)(stop - start) / 1000000.0;
        defaultHttpDataFactory.cleanAllHttpData();
        defaultHttpDataFactory.cleanRequestHttpData((HttpRequest)req);
        decoder.destroy();
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Benchmark
    public double multipartRequestDecoderHighDisabledLevel() {
        ResourceLeakDetector.Level level = ResourceLeakDetector.getLevel();
        try {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
            double d = this.testHighNumberChunks(false, true);
            return d;
        }
        finally {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Benchmark
    public double multipartRequestDecoderBigDisabledLevel() {
        ResourceLeakDetector.Level level = ResourceLeakDetector.getLevel();
        try {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
            double d = this.testHighNumberChunks(true, true);
            return d;
        }
        finally {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Benchmark
    public double multipartRequestDecoderHighSimpleLevel() {
        ResourceLeakDetector.Level level = ResourceLeakDetector.getLevel();
        try {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.SIMPLE);
            double d = this.testHighNumberChunks(false, true);
            return d;
        }
        finally {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Benchmark
    public double multipartRequestDecoderBigSimpleLevel() {
        ResourceLeakDetector.Level level = ResourceLeakDetector.getLevel();
        try {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.SIMPLE);
            double d = this.testHighNumberChunks(true, true);
            return d;
        }
        finally {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Benchmark
    public double multipartRequestDecoderHighAdvancedLevel() {
        ResourceLeakDetector.Level level = ResourceLeakDetector.getLevel();
        try {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.ADVANCED);
            double d = this.testHighNumberChunks(false, true);
            return d;
        }
        finally {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Benchmark
    public double multipartRequestDecoderBigAdvancedLevel() {
        ResourceLeakDetector.Level level = ResourceLeakDetector.getLevel();
        try {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.ADVANCED);
            double d = this.testHighNumberChunks(true, true);
            return d;
        }
        finally {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Benchmark
    public double multipartRequestDecoderHighParanoidLevel() {
        ResourceLeakDetector.Level level = ResourceLeakDetector.getLevel();
        try {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
            double d = this.testHighNumberChunks(false, true);
            return d;
        }
        finally {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Benchmark
    public double multipartRequestDecoderBigParanoidLevel() {
        ResourceLeakDetector.Level level = ResourceLeakDetector.getLevel();
        try {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
            double d = this.testHighNumberChunks(true, true);
            return d;
        }
        finally {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)level);
        }
    }
}

