/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.microbench.channel.EmbeddedChannelHandlerContext;
import io.netty.util.ReferenceCounted;

public abstract class EmbeddedChannelWriteReleaseHandlerContext
extends EmbeddedChannelHandlerContext {
    protected EmbeddedChannelWriteReleaseHandlerContext(ByteBufAllocator alloc, ChannelHandler handler) {
        this(alloc, handler, new EmbeddedChannel());
    }

    protected EmbeddedChannelWriteReleaseHandlerContext(ByteBufAllocator alloc, ChannelHandler handler, EmbeddedChannel channel) {
        super(alloc, handler, channel);
    }

    @Override
    protected abstract void handleException(Throwable var1);

    @Override
    public final ChannelFuture write(Object msg) {
        return this.write(msg, this.newPromise());
    }

    @Override
    public final ChannelFuture write(Object msg, ChannelPromise promise) {
        try {
            if (msg instanceof ReferenceCounted) {
                ((ReferenceCounted)msg).release();
                promise.setSuccess();
            } else {
                this.channel().write(msg, promise);
            }
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    @Override
    public final ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        try {
            if (msg instanceof ReferenceCounted) {
                ((ReferenceCounted)msg).release();
                promise.setSuccess();
            } else {
                this.channel().writeAndFlush(msg, promise);
            }
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    @Override
    public final ChannelFuture writeAndFlush(Object msg) {
        return this.writeAndFlush(msg, this.newPromise());
    }
}

