/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.internal.SuppressJava6Requirement;
import java.util.SplittableRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=2)
@Warmup(iterations=5, time=1)
@Measurement(iterations=8, time=1)
public class ByteBufIndexOfBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"7", "16", "23", "32"})
    int size;
    @Param(value={"4", "11"})
    int logPermutations;
    @Param(value={"1"})
    int seed;
    int permutations;
    ByteBuf[] data;
    private int i;
    @Param(value={"0"})
    private byte needleByte;
    @Param(value={"true", "false"})
    private boolean direct;
    @Param(value={"true", "false"})
    private boolean noUnsafe;
    @Param(value={"true", "false"})
    private boolean pooled;

    @Setup(value=Level.Trial)
    @SuppressJava6Requirement(reason="using SplittableRandom to reliably produce data")
    public void init() {
        System.setProperty("io.netty.noUnsafe", Boolean.valueOf(this.noUnsafe).toString());
        SplittableRandom random = new SplittableRandom(this.seed);
        this.permutations = 1 << this.logPermutations;
        this.data = new ByteBuf[this.permutations];
        PooledByteBufAllocator allocator = this.pooled ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT;
        for (int i = 0; i < this.permutations; ++i) {
            this.data[i] = this.direct ? allocator.directBuffer(this.size, this.size) : allocator.heapBuffer(this.size, this.size);
            for (int j = 0; j < this.size; ++j) {
                int value = random.nextInt(-128, 128);
                if (value == this.needleByte) {
                    value = this.needleByte != 1 ? 1 : 0;
                }
                this.data[i].setByte(j, value);
            }
            int foundIndex = random.nextInt(Math.max(0, this.size - 8), this.size);
            this.data[i].setByte(foundIndex, (int)this.needleByte);
        }
    }

    private ByteBuf getData() {
        return this.data[this.i++ & this.permutations - 1];
    }

    @Benchmark
    public int indexOf() {
        return this.getData().indexOf(0, this.size, this.needleByte);
    }

    @TearDown
    public void releaseBuffers() {
        for (ByteBuf buffer : this.data) {
            buffer.release();
        }
    }
}

