/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbenchmark.common;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.NetUtil;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Threads(value=4)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class NetUtilBenchmark
extends AbstractMicrobenchmark {
    private static final String[] invalidIpV4Hosts = new String[]{"1.256.3.4", "256.0.0.1", "1.1.1.1.1", "x.255.255.255", "0.1:0.0", "0.1.0.0:", "127.0.0.", "1.2..4", "192.0.1", "192.0.1.1.1", "192.0.1.a", "19a.0.1.1", "a.0.1.1", ".0.1.1", "127.0.0", "192.0.1.256", "0.0.200.259", "1.1.-1.1", "1.1. 1.1", "1.1.1.1 ", "1.1.+1.1", "0.0x1.0.255", "0.01x.0.255", "0.x01.0.255", "0.-.0.0", "0..0.0", "0.A.0.0", "0.1111.0.0", "..."};
    private static final String[] invalidIpV6Hosts = new String[]{"Obvious Garbage", "0:1:2:3:4:5:6:7:8", "0:1:2:3:4:5:6", "0:1:2:3:4:5:6:x", "0:1:2:3:4:5:6::7", "0:1:2:3:4:5:6:7::", "::0:1:2:3:4:5:6:7", "1:2:3:4:5:6:7:", ":1:2:3:4:5:6:7", "0:1:2:3:4:5::7:", "0:1:2:3:4::7:", "0:1:2:3::7:", "0:1:2::7:", "0:1::7:", "0::7:", "::0:1:2:3:4:5:7:", "::0:1:2:3:4:7:", "::0:1:2:3:7:", "::0:1:2:7:", "::0:1:7:", "::7:", ":1:2:3:4:5:6:7:", ":1:2:3:4:5:6:", ":1:2:3:4:5:", ":1:2:3:4:", ":1:2:3:", ":1:2:", ":1:", ":1::2:3:4:5:6:7", ":1::3:4:5:6:7", ":1::4:5:6:7", ":1::5:6:7", ":1::6:7", ":1::7", ":1:2:3:4:5:6::7", ":1:3:4:5:6::7", ":1:4:5:6::7", ":1:5:6::7", ":1:6::7", ":1::", ":1:2:3:4:5:6:7::", ":1:3:4:5:6:7::", ":1:4:5:6:7::", ":1:5:6:7::", ":1:6:7::", ":1:7::", "1::2:3:4:5:6::", "::1:2:3:4:5::6", "::1:2:3:4:5:6::", "::1:2:3:4:5::", "::1:2:3:4::", "::1:2:3::", "::1:2::", "::0::", "12::0::12", "0::1:2:3:4:5:6:7", "0:1:2:3:4:5:6:789abcdef", "0:1:2:3::x", "0:1:2:::3", "0:1:2:3::abcde", "0:1", "0:0:0:0:0:x:10.0.0.1", "0:0:0:0:0:0:10.0.0.x", "0:0:0:0:0:00000:10.0.0.1", "0:0:0:0:0:0:0:10.0.0.1", "0:0:0:0:0:10.0.0.1", "0:0:0:0:0:0:10.0.0.0.1", "0:0:0:0:0:0:10.0.1", "0:0:0:0:0:0:10..0.0.1", "0:0:0:0:0:0:.0.0.1", "0:0:0:0:0:0:.10.0.0.1", "0:0:0:0:0:0:10.0.0.", "0:0:0:0:0:0:10.0.0.1.", "::fffx:192.168.0.1", "::ffff:192.168.0.x", ":::ffff:192.168.0.1", "::fffff:192.168.0.1", "::ffff:1923.168.0.1", ":ffff:192.168.0.1", "::ffff:192.168.0.1.2", "::ffff:192.168.0", "::ffff:192.168..0.1", "x:0:0:0:0:0:10.0.0.1", "0:0:0:0:0:0:x.0.0.1", "00000:0:0:0:0:0:10.0.0.1", "0:0:0:0:0:0:10.0.0.1000", "0:0:0:0:0:0:0:10.0.0.1", "0:0:0:0:0:10.0.0.1", "0:0:0:0:0:10.0.0.1:", ":0:0:0:0:0:10.0.0.1", "0:0:0:0::10.0.0.1:", ":0:0:0:0::10.0.0.1", "0:0:0:0:0:0:10.0.0.0.1", "0:0:0:0:0:0:10.0.1", "0:0:0:0:0:0:10.0.0..1", "", ":", ":::", "2001:0:4136:e378:8000:63bf:3fff:fdd2:", ":aaaa:bbbb:cccc:dddd:eeee:ffff:1111:2222", "1234:2345:3456:4567:5678:6789::X890", "::ffff:255.255.255.255.", "::ffff:0.0.1111.0", "::ffff:0.0..0", "::ffff:127.0.0.", "::ffff:127.0.0.a", "::ffff:a.0.0.1", "::ffff:127.a.0.1", "::ffff:127.0.a.1", "::ffff:1.2.4", "::ffff:192.168.0.1.255", ":ffff:192.168.0.1.255", "::ffff:255.255:255.255.", "0:0:0::0:0:00f.0.0.1", "0:0:0:0:0:fff:1.0.0.1", "0:0:0:0:0:ff00:1.0.0.1", "0:0:0:0:0:ff:1.0.0.1", "0:0:0:0:0:fffff:1.0.0.1", "0:0:0:0:0:0:ffff:1.0.0.1", "::0:0:0:0:0:ffff:1.0.0.1", "0:0:0:0:0:0::1.0.0.1", "0:0:0:0:0:00000:1.0.0.1", "0:0:0:0:ffff:1.0.0.1", "ffff:192.168.0.1", "0:0:0:0:0:ffff::10.0.0.1", "0:0:0:0:ffff::10.0.0.1", "0:0:0:ffff::10.0.0.1", "0:0:ffff::10.0.0.1", "0:ffff::10.0.0.1", "ffff::10.0.0.1", "1:0:0:0:0:ffff:10.0.0.1", "0:0:0:0:ffff:ffff:1.0.0.1", "::1:2:3:4:5:6.7.8.9", "0:0:0:0:0:0:ffff:10.0.0.1", ":1.2.3.4", "::.2.3.4", "::ffff:0.1.2."};

    @Benchmark
    public int useGetByNameIpv4() {
        int invalidCount = 0;
        for (String testEntry : invalidIpV4Hosts) {
            if (NetUtil.getByName((CharSequence)testEntry) != null) continue;
            ++invalidCount;
        }
        return invalidCount;
    }

    @Benchmark
    public int useGetByNameIpv6() {
        int invalidCount = 0;
        for (String testEntry : invalidIpV6Hosts) {
            if (NetUtil.getByName((CharSequence)testEntry) != null) continue;
            ++invalidCount;
        }
        return invalidCount;
    }

    @Benchmark
    public int useIsValidIpv6() {
        int invalidCount = 0;
        for (String host : invalidIpV6Hosts) {
            if (NetUtil.isValidIpV6Address((String)host)) continue;
            ++invalidCount;
        }
        return invalidCount;
    }

    @Benchmark
    public int useIsValidIpv4() {
        int invalidCount = 0;
        for (String host : invalidIpV4Hosts) {
            if (NetUtil.isValidIpV4Address((String)host)) continue;
            ++invalidCount;
        }
        return invalidCount;
    }
}

