/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.util;

import io.netty.microbench.util.AbstractMicrobenchmarkBase;
import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadExecutorMap;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;

@Fork(value=2)
public class AbstractMicrobenchmark
extends AbstractMicrobenchmarkBase {
    protected static final int DEFAULT_FORKS = 2;
    private final String[] jvmArgs;

    public AbstractMicrobenchmark() {
        this(true, false);
    }

    public AbstractMicrobenchmark(boolean disableAssertions) {
        this(disableAssertions, false);
    }

    public AbstractMicrobenchmark(boolean disableAssertions, boolean disableHarnessExecutor) {
        ArrayList<String> jvmArgs = new ArrayList<String>(Arrays.asList(BASE_JVM_ARGS));
        jvmArgs.add("-Xms768m");
        jvmArgs.add("-Xmx768m");
        jvmArgs.add("-XX:MaxDirectMemorySize=768m");
        if (PlatformDependent.javaVersion() < 15) {
            jvmArgs.add("-XX:BiasedLockingStartupDelay=0");
        }
        if (!disableHarnessExecutor) {
            jvmArgs.add("-Djmh.executor=CUSTOM");
            jvmArgs.add("-Djmh.executor.class=" + HarnessExecutor.class.getName());
        }
        if (disableAssertions) {
            AbstractMicrobenchmark.removeAssertions(jvmArgs);
            jvmArgs.add("-ea:io.netty.microbench...");
        }
        this.jvmArgs = jvmArgs.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    @Override
    protected String[] jvmArgs() {
        return this.jvmArgs;
    }

    @Override
    protected ChainedOptionsBuilder newOptionsBuilder() throws Exception {
        ChainedOptionsBuilder runnerOptions = super.newOptionsBuilder();
        if (this.getForks() > 0) {
            runnerOptions.forks(this.getForks());
        }
        return runnerOptions;
    }

    protected int getForks() {
        return SystemPropertyUtil.getInt((String)"forks", (int)-1);
    }

    public static final class HarnessExecutor
    extends ThreadPoolExecutor {
        private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractMicrobenchmark.class);

        public HarnessExecutor(int maxThreads, String prefix) {
            super(maxThreads, maxThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory(prefix));
            AbstractEventExecutor eventExecutor = new AbstractEventExecutor(){

                public void shutdown() {
                    throw new UnsupportedOperationException();
                }

                public boolean inEventLoop(Thread thread) {
                    return thread instanceof FastThreadLocalThread;
                }

                public boolean isShuttingDown() {
                    throw new UnsupportedOperationException();
                }

                public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
                    throw new UnsupportedOperationException();
                }

                public Future<?> terminationFuture() {
                    throw new UnsupportedOperationException();
                }

                public boolean isShutdown() {
                    throw new UnsupportedOperationException();
                }

                public boolean isTerminated() {
                    throw new UnsupportedOperationException();
                }

                public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                    throw new UnsupportedOperationException();
                }

                public void execute(Runnable command) {
                    throw new UnsupportedOperationException();
                }
            };
            this.setThreadFactory(ThreadExecutorMap.apply((ThreadFactory)this.getThreadFactory(), (EventExecutor)eventExecutor));
            logger.debug("Using harness executor");
        }
    }
}

