/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.snappy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.compression.Snappy;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Threads(value=1)
@Warmup(iterations=5)
@Measurement(iterations=3)
public class SnappyDirectBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"true", "false"})
    public boolean reuseHashTable;
    private ByteBuf buffer;
    private Snappy snappy;
    private ByteBuf in;
    private ByteBuf out;
    @Param(value={"4096", "2048", "1024", "512", "256", "128"})
    private int bufferSizeInBytes;

    @Setup
    public void setup() throws UnsupportedEncodingException {
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        this.buffer = allocator.buffer(this.bufferSizeInBytes);
        this.snappy = this.reuseHashTable ? Snappy.withHashTableReuse() : new Snappy();
        byte[] compressibleByteArray = new byte[this.buffer.writableBytes()];
        Arrays.fill(compressibleByteArray, (byte)1);
        this.buffer.writeBytes(compressibleByteArray);
        this.in = Unpooled.wrappedBuffer((byte[])compressibleByteArray);
        this.out = Unpooled.directBuffer();
    }

    @Benchmark
    public ByteBuf encode(AllocationMetrics allocationMetrics) {
        int length = this.in.readableBytes();
        this.snappy.encode(this.in, this.out, length);
        this.in.resetReaderIndex();
        AllocationMetrics allocationMetrics2 = allocationMetrics;
        allocationMetrics2.inputSize = allocationMetrics2.inputSize + (long)length;
        allocationMetrics2 = allocationMetrics;
        allocationMetrics2.outputSize = allocationMetrics2.outputSize + (long)this.out.readableBytes();
        this.out.setIndex(0, 0);
        return this.out;
    }

    @TearDown(value=Level.Trial)
    public void teardown() {
        this.buffer.release();
        this.buffer = null;
        this.out.release();
        this.out = null;
    }

    @AuxCounters(value=AuxCounters.Type.OPERATIONS)
    @State(value=Scope.Thread)
    public static class AllocationMetrics {
        private long inputSize;
        private long outputSize;

        public long compressedRatio() {
            return this.inputSize / this.outputSize;
        }
    }
}

