/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.search;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.buffer.search.AbstractMultiSearchProcessorFactory;
import io.netty.buffer.search.AbstractSearchProcessorFactory;
import io.netty.buffer.search.SearchProcessorFactory;
import io.netty.microbench.search.ByteBufType;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.ByteProcessor;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Warmup(iterations=5)
@Measurement(iterations=5)
@Fork(value=1)
public class SearchBenchmark
extends AbstractMicrobenchmark {
    private static final long SEED = 123L;
    @Param
    public Input input;
    @Param
    public ByteBufType bufferType;
    private Random rnd;
    private ByteBuf needle;
    private ByteBuf haystack;
    private byte[] needleBytes;
    private byte[] haystackBytes;
    private SearchProcessorFactory kmpFactory;
    private SearchProcessorFactory bitapFactory;
    private SearchProcessorFactory ahoCorasicFactory;

    @Setup
    public void setup() {
        this.rnd = new Random(123L);
        this.needleBytes = this.input.getNeedle(this.rnd);
        this.haystackBytes = this.input.getHaystack(this.rnd);
        this.needle = Unpooled.wrappedBuffer((byte[])this.needleBytes);
        this.haystack = this.bufferType.newBuffer(this.haystackBytes);
        this.kmpFactory = AbstractSearchProcessorFactory.newKmpSearchProcessorFactory((byte[])this.needleBytes);
        this.ahoCorasicFactory = AbstractMultiSearchProcessorFactory.newAhoCorasicSearchProcessorFactory((byte[][])new byte[][]{this.needleBytes});
        if (this.needleBytes.length <= 64) {
            this.bitapFactory = AbstractSearchProcessorFactory.newBitapSearchProcessorFactory((byte[])this.needleBytes);
        }
    }

    @TearDown
    public void teardown() {
        this.needle.release();
        this.haystack.release();
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public int indexOf() {
        return ByteBufUtil.indexOf((ByteBuf)this.needle, (ByteBuf)this.haystack);
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public int kmp() {
        return this.haystack.forEachByte((ByteProcessor)this.kmpFactory.newSearchProcessor());
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public int bitap() {
        return this.haystack.forEachByte((ByteProcessor)this.bitapFactory.newSearchProcessor());
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public int ahoCorasic() {
        return this.haystack.forEachByte((ByteProcessor)this.ahoCorasicFactory.newSearchProcessor());
    }

    private static byte[] randomBytes(Random rnd, int size, int from, int to) {
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = (byte)(from + rnd.nextInt(to - from + 1));
        }
        return bytes;
    }

    public static enum Input {
        RANDOM_256B{

            @Override
            byte[] getNeedle(Random rnd) {
                return new byte[]{97, 98, 99, 100, 101, 102, 103, 104};
            }

            @Override
            byte[] getHaystack(Random rnd) {
                return SearchBenchmark.randomBytes(rnd, 256, 32, 127);
            }
        }
        ,
        RANDOM_2KB{

            @Override
            byte[] getNeedle(Random rnd) {
                return new byte[]{97, 98, 99, 100, 101, 102, 103, 104};
            }

            @Override
            byte[] getHaystack(Random rnd) {
                return SearchBenchmark.randomBytes(rnd, 2048, 32, 127);
            }
        }
        ,
        PREDICTABLE{

            @Override
            byte[] getNeedle(Random rnd) {
                return new byte[64];
            }

            @Override
            byte[] getHaystack(Random rnd) {
                byte[] bytes = SearchBenchmark.randomBytes(rnd, 2048, 1, 255);
                Arrays.fill(bytes, bytes.length - 64, bytes.length, (byte)0);
                return bytes;
            }
        }
        ,
        UNPREDICTABLE{

            @Override
            byte[] getNeedle(Random rnd) {
                return SearchBenchmark.randomBytes(rnd, 64, 0, 1);
            }

            @Override
            byte[] getHaystack(Random rnd) {
                return SearchBenchmark.randomBytes(rnd, 2048, 0, 1);
            }
        }
        ,
        WORST_CASE{

            @Override
            byte[] getNeedle(Random rnd) {
                byte[] needle = new byte[1024];
                Arrays.fill(needle, (byte)97);
                needle[needle.length - 1] = 98;
                return needle;
            }

            @Override
            byte[] getHaystack(Random rnd) {
                byte[] haystack = new byte[2048];
                Arrays.fill(haystack, (byte)97);
                return haystack;
            }
        };


        abstract byte[] getNeedle(Random var1);

        abstract byte[] getHaystack(Random var1);
    }
}

