/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.microbench.http.HttpRequestDecoderUtils;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class HttpFragmentedRequestDecoderBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"64", "128"})
    public int headerFragmentBytes;
    @Param(value={"false", "true"})
    public boolean direct;
    @Param(value={"false", "true"})
    public boolean pooled;
    @Param(value={"true", "false"})
    public boolean validateHeaders;
    private EmbeddedChannel channel;
    private ByteBuf[] fragmentedRequest;

    private static ByteBuf[] stepsBuffers(ByteBufAllocator alloc, byte[] content, int fragmentSize, boolean direct) {
        int amount;
        int headerLength = content.length - 120;
        ArrayList<ByteBuf> bufs = new ArrayList<ByteBuf>();
        for (int a = 0; a < headerLength; a += amount) {
            amount = fragmentSize;
            if (a + amount > headerLength) {
                amount = headerLength - a;
            }
            ByteBuf buf = direct ? alloc.directBuffer(amount, amount) : alloc.heapBuffer(amount, amount);
            buf.writeBytes(content, a, amount);
            bufs.add(buf);
        }
        ByteBuf buf = direct ? alloc.directBuffer(120, 120) : alloc.heapBuffer(120, 120);
        buf.writeBytes(content, content.length - 120, 120);
        bufs.add(buf);
        return bufs.toArray(new ByteBuf[0]);
    }

    @Setup
    public void initPipeline() {
        PooledByteBufAllocator allocator = this.pooled ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT;
        this.fragmentedRequest = HttpFragmentedRequestDecoderBenchmark.stepsBuffers((ByteBufAllocator)allocator, HttpRequestDecoderUtils.CONTENT_MIXED_DELIMITERS, this.headerFragmentBytes, this.direct);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(4096, 8192, 8192, this.validateHeaders, 128)});
    }

    @TearDown
    public void releaseStepBuffers() {
        for (ByteBuf buf : this.fragmentedRequest) {
            buf.release();
        }
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public void testDecodeWholeRequestInMultipleStepsMixedDelimiters() {
        EmbeddedChannel channel = this.channel;
        for (ByteBuf buf : this.fragmentedRequest) {
            Object o;
            buf.resetReaderIndex();
            buf.retain();
            channel.writeInbound(new Object[]{buf});
            Queue decoded = channel.inboundMessages();
            while ((o = decoded.poll()) != null) {
                ReferenceCountUtil.release(o);
            }
        }
    }
}

