/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.snoop;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.http.snoop.HttpSnoopClientInitializer;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URI;

public final class HttpSnoopClient {
    static final String URL = System.getProperty("url", "http://127.0.0.1:8080/");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        URI uri = new URI(URL);
        String scheme = uri.getScheme() == null ? "http" : uri.getScheme();
        String host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            if ("http".equalsIgnoreCase(scheme)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(scheme)) {
                port = 443;
            }
        }
        if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            System.err.println("Only HTTP(S) is supported.");
            return;
        }
        boolean ssl = "https".equalsIgnoreCase(scheme);
        SslContext sslCtx = ssl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new HttpSnoopClientInitializer(sslCtx));
            Channel ch = b.connect(host, port).sync().channel();
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri.getRawPath(), Unpooled.EMPTY_BUFFER);
            request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)host);
            request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
            request.headers().set((CharSequence)HttpHeaderNames.COOKIE, (Object)ClientCookieEncoder.STRICT.encode(new Cookie[]{new DefaultCookie("my-cookie", "foo"), new DefaultCookie("another-cookie", "bar")}));
            ch.writeAndFlush((Object)request);
            ch.closeFuture().sync();
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

