/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.uptime;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.uptime.UptimeClientHandler;
import io.netty.handler.timeout.IdleStateHandler;

public final class UptimeClient {
    static final String HOST = System.getProperty("host", "127.0.0.1");
    static final int PORT = Integer.parseInt(System.getProperty("port", "8080"));
    static final int RECONNECT_DELAY = Integer.parseInt(System.getProperty("reconnectDelay", "5"));
    private static final int READ_TIMEOUT = Integer.parseInt(System.getProperty("readTimeout", "10"));
    private static final UptimeClientHandler handler = new UptimeClientHandler();
    private static final Bootstrap bs = new Bootstrap();

    public static void main(String[] args) throws Exception {
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
        ((Bootstrap)((Bootstrap)bs.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).remoteAddress(HOST, PORT).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(READ_TIMEOUT, 0, 0), handler});
            }
        });
        bs.connect();
    }

    static void connect() {
        bs.connect().addListener(future -> {
            if (future.cause() != null) {
                UptimeClient.handler.startTime = -1L;
                handler.println("Failed to connect: " + future.cause());
            }
        });
    }
}

