/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.rendezvous;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.udt.UdtMessage;
import io.netty.channel.udt.nio.NioUdtProvider;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MsgEchoPeerHandler
extends SimpleChannelInboundHandler<UdtMessage> {
    private static final Logger log = Logger.getLogger(MsgEchoPeerHandler.class.getName());
    private final UdtMessage message;
    final Meter meter = Metrics.newMeter(MsgEchoPeerHandler.class, (String)"rate", (String)"bytes", (TimeUnit)TimeUnit.SECONDS);

    public MsgEchoPeerHandler(int messageSize) {
        super(false);
        ByteBuf byteBuf = Unpooled.buffer((int)messageSize);
        for (int i = 0; i < byteBuf.capacity(); ++i) {
            byteBuf.writeByte((int)((byte)i));
        }
        this.message = new UdtMessage(byteBuf);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("ECHO active " + NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
        ctx.writeAndFlush((Object)this.message);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.log(Level.WARNING, "close the connection when an exception is raised", cause);
        ctx.close();
    }

    public void channelRead0(ChannelHandlerContext ctx, UdtMessage message) throws Exception {
        this.meter.mark((long)message.content().readableBytes());
        ctx.write((Object)message);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }
}

