/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.bytes;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.udt.nio.NioUdtProvider;
import java.util.logging.Level;
import java.util.logging.Logger;

@ChannelHandler.Sharable
public class ByteEchoServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = Logger.getLogger(ByteEchoServerHandler.class.getName());

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ctx.write(msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.log(Level.WARNING, "close the connection when an exception is raised", cause);
        ctx.close();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("ECHO active " + NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
    }
}

