/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.spdy.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.securechat.SecureChatSslContextFactory;
import io.netty.example.spdy.server.SpdyOrHttpHandler;
import io.netty.example.spdy.server.SpdyServerProvider;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.npn.NextProtoNego;

public class SpdyServerInitializer
extends ChannelInitializer<SocketChannel> {
    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        SSLEngine engine = SecureChatSslContextFactory.getServerContext().createSSLEngine();
        engine.setUseClientMode(false);
        p.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        NextProtoNego.put((SSLEngine)engine, (NextProtoNego.Provider)new SpdyServerProvider());
        NextProtoNego.debug = true;
        p.addLast("handler", (ChannelHandler)new SpdyOrHttpHandler());
    }
}

