/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.spdy.client;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.securechat.SecureChatSslContextFactory;
import io.netty.example.spdy.client.HttpResponseClientHandler;
import io.netty.example.spdy.client.SpdyClientProvider;
import io.netty.example.spdy.client.SpdyClientStreamIdHandler;
import io.netty.example.spdy.client.SpdyFrameLogger;
import io.netty.handler.codec.spdy.SpdyFrameCodec;
import io.netty.handler.codec.spdy.SpdyHttpDecoder;
import io.netty.handler.codec.spdy.SpdyHttpEncoder;
import io.netty.handler.codec.spdy.SpdySessionHandler;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.internal.logging.InternalLogLevel;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.npn.NextProtoNego;

public class SpdyClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final HttpResponseClientHandler httpResponseHandler;
    private static final int MAX_SPDY_CONTENT_LENGTH = 0x100000;

    public SpdyClientInitializer(HttpResponseClientHandler httpResponseHandler) {
        this.httpResponseHandler = httpResponseHandler;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        SSLEngine engine = SecureChatSslContextFactory.getClientContext().createSSLEngine();
        engine.setUseClientMode(true);
        NextProtoNego.put((SSLEngine)engine, (NextProtoNego.Provider)new SpdyClientProvider());
        NextProtoNego.debug = true;
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        pipeline.addLast("spdyFrameCodec", (ChannelHandler)new SpdyFrameCodec(SpdyVersion.SPDY_3_1));
        pipeline.addLast("spdyFrameLogger", (ChannelHandler)new SpdyFrameLogger(InternalLogLevel.INFO));
        pipeline.addLast("spdySessionHandler", (ChannelHandler)new SpdySessionHandler(SpdyVersion.SPDY_3_1, false));
        pipeline.addLast("spdyHttpEncoder", (ChannelHandler)new SpdyHttpEncoder(SpdyVersion.SPDY_3_1));
        pipeline.addLast("spdyHttpDecoder", (ChannelHandler)new SpdyHttpDecoder(SpdyVersion.SPDY_3_1, 0x100000));
        pipeline.addLast("spdyStreamIdHandler", (ChannelHandler)new SpdyClientStreamIdHandler());
        pipeline.addLast("httpHandler", (ChannelHandler)this.httpResponseHandler);
    }
}

