/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.factorial;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.factorial.BigIntegerDecoder;
import io.netty.example.factorial.FactorialClientHandler;
import io.netty.example.factorial.NumberEncoder;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;

public class FactorialClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final int count;

    public FactorialClientInitializer(int count) {
        this.count = count;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("deflater", (ChannelHandler)ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.GZIP));
        pipeline.addLast("inflater", (ChannelHandler)ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP));
        pipeline.addLast("decoder", (ChannelHandler)new BigIntegerDecoder());
        pipeline.addLast("encoder", (ChannelHandler)new NumberEncoder());
        pipeline.addLast("handler", (ChannelHandler)new FactorialClientHandler(this.count));
    }
}

