/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsReceivedConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DecoratingHttp2ConnectionEncoderTest {
    @Test
    public void testConsumeReceivedSettingsThrows() {
        Http2ConnectionEncoder encoder = (Http2ConnectionEncoder)Mockito.mock(Http2ConnectionEncoder.class);
        final DecoratingHttp2ConnectionEncoder decoratingHttp2ConnectionEncoder = new DecoratingHttp2ConnectionEncoder(encoder);
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                decoratingHttp2ConnectionEncoder.consumeReceivedSettings(Http2Settings.defaultSettings());
            }
        });
    }

    @Test
    public void testConsumeReceivedSettingsDelegate() {
        TestHttp2ConnectionEncoder encoder = (TestHttp2ConnectionEncoder)Mockito.mock(TestHttp2ConnectionEncoder.class);
        DecoratingHttp2ConnectionEncoder decoratingHttp2ConnectionEncoder = new DecoratingHttp2ConnectionEncoder((Http2ConnectionEncoder)encoder);
        Http2Settings settings = Http2Settings.defaultSettings();
        decoratingHttp2ConnectionEncoder.consumeReceivedSettings(Http2Settings.defaultSettings());
        ((TestHttp2ConnectionEncoder)Mockito.verify((Object)encoder, (VerificationMode)Mockito.times((int)1))).consumeReceivedSettings((Http2Settings)Mockito.eq((Object)settings));
    }

    private static interface TestHttp2ConnectionEncoder
    extends Http2ConnectionEncoder,
    Http2SettingsReceivedConsumer {
    }
}

