/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.AsciiString;
import io.netty.handler.codec.TextHeaders;
import java.util.Map;

final class HttpHeadersEncoder
implements TextHeaders.EntryVisitor {
    private final ByteBuf buf;

    HttpHeadersEncoder(ByteBuf buf) {
        this.buf = buf;
    }

    public boolean visit(Map.Entry<CharSequence, CharSequence> entry) throws Exception {
        CharSequence name = entry.getKey();
        CharSequence value = entry.getValue();
        ByteBuf buf = this.buf;
        int nameLen = name.length();
        int valueLen = value.length();
        int entryLen = nameLen + valueLen + 4;
        int offset = buf.writerIndex();
        buf.ensureWritable(entryLen);
        HttpHeadersEncoder.writeAscii(buf, offset, name, nameLen);
        offset += nameLen;
        buf.setByte(offset++, 58);
        buf.setByte(offset++, 32);
        HttpHeadersEncoder.writeAscii(buf, offset, value, valueLen);
        offset += valueLen;
        buf.setByte(offset++, 13);
        buf.setByte(offset++, 10);
        buf.writerIndex(offset);
        return true;
    }

    private static void writeAscii(ByteBuf buf, int offset, CharSequence value, int valueLen) {
        if (value instanceof AsciiString) {
            HttpHeadersEncoder.writeAsciiString(buf, offset, (AsciiString)value, valueLen);
        } else {
            HttpHeadersEncoder.writeCharSequence(buf, offset, value, valueLen);
        }
    }

    private static void writeAsciiString(ByteBuf buf, int offset, AsciiString value, int valueLen) {
        value.copy(0, buf, offset, valueLen);
    }

    private static void writeCharSequence(ByteBuf buf, int offset, CharSequence value, int valueLen) {
        for (int i = 0; i < valueLen; ++i) {
            buf.setByte(offset++, HttpHeadersEncoder.c2b(value.charAt(i)));
        }
    }

    private static int c2b(char ch) {
        return ch < '\u0100' ? (int)ch : 63;
    }
}

