/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socksx.v5;

import io.netty.contrib.handler.codec.socksx.v5.AbstractSocks5Message;
import io.netty.contrib.handler.codec.socksx.v5.Socks5PasswordAuthRequest;
import io.netty5.handler.codec.DecoderResult;
import io.netty5.util.internal.StringUtil;
import java.util.Objects;

public class DefaultSocks5PasswordAuthRequest
extends AbstractSocks5Message
implements Socks5PasswordAuthRequest {
    private final String username;
    private final String password;

    public DefaultSocks5PasswordAuthRequest(String username, String password) {
        Objects.requireNonNull(username, "username");
        Objects.requireNonNull(password, "password");
        if (username.length() > 255) {
            throw new IllegalArgumentException("username: **** (expected: less than 256 chars)");
        }
        if (password.length() > 255) {
            throw new IllegalArgumentException("password: **** (expected: less than 256 chars)");
        }
        if (DefaultSocks5PasswordAuthRequest.containNonAscii(username)) {
            throw new IllegalArgumentException("username: **** (contains non-ASCII characters, which is not allowed)");
        }
        if (DefaultSocks5PasswordAuthRequest.containNonAscii(password)) {
            throw new IllegalArgumentException("password: **** (contains non-ASCII characters, which is not allowed)");
        }
        this.username = username;
        this.password = password;
    }

    private static boolean containNonAscii(String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') continue;
            return true;
        }
        return false;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String password() {
        return this.password;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(StringUtil.simpleClassName((Object)this));
        DecoderResult decoderResult = this.decoderResult();
        if (!decoderResult.isSuccess()) {
            buf.append("(decoderResult: ");
            buf.append(decoderResult);
            buf.append(", username: ");
        } else {
            buf.append("(username: ");
        }
        buf.append(this.username());
        buf.append(", password: ****)");
        return buf.toString();
    }
}

