/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socks;

import io.netty.contrib.handler.codec.socks.SocksAuthScheme;
import io.netty.contrib.handler.codec.socks.SocksCommonUtils;
import io.netty.contrib.handler.codec.socks.SocksInitResponse;
import io.netty.contrib.handler.codec.socks.SocksProtocolVersion;
import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;

public class SocksInitResponseDecoder
extends ByteToMessageDecoder {
    private State state = State.CHECK_PROTOCOL_VERSION;

    protected void decode(ChannelHandlerContext ctx, Buffer buffer) throws Exception {
        switch (this.state) {
            case CHECK_PROTOCOL_VERSION: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                if (buffer.readByte() != SocksProtocolVersion.SOCKS5.byteValue()) {
                    ctx.fireChannelRead((Object)SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE);
                    break;
                }
                this.state = State.READ_PREFERRED_AUTH_TYPE;
            }
            case READ_PREFERRED_AUTH_TYPE: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                SocksAuthScheme authScheme = SocksAuthScheme.valueOf(buffer.readByte());
                ctx.fireChannelRead((Object)new SocksInitResponse(authScheme));
                break;
            }
            default: {
                throw new Error();
            }
        }
        ctx.pipeline().remove((ChannelHandler)this);
    }

    private static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_PREFERRED_AUTH_TYPE;

    }
}

