/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socks;

import io.netty.contrib.handler.codec.socks.SocksAuthScheme;
import io.netty.contrib.handler.codec.socks.SocksRequest;
import io.netty.contrib.handler.codec.socks.SocksRequestType;
import io.netty5.buffer.Buffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class SocksInitRequest
extends SocksRequest {
    private final List<SocksAuthScheme> authSchemes;

    public SocksInitRequest(List<SocksAuthScheme> authSchemes) {
        super(SocksRequestType.INIT);
        Objects.requireNonNull(authSchemes, "authSchemes");
        this.authSchemes = authSchemes;
    }

    public List<SocksAuthScheme> authSchemes() {
        return Collections.unmodifiableList(this.authSchemes);
    }

    @Override
    public void encodeAsBuffer(Buffer buffer) {
        buffer.writeByte(this.protocolVersion().byteValue());
        buffer.writeByte((byte)this.authSchemes.size());
        for (SocksAuthScheme authScheme : this.authSchemes) {
            buffer.writeByte(authScheme.byteValue());
        }
    }
}

