/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socks;

import io.netty.contrib.handler.codec.socks.SocksRequest;
import io.netty.contrib.handler.codec.socks.SocksResponse;
import io.netty.contrib.handler.codec.socks.UnknownSocksRequest;
import io.netty.contrib.handler.codec.socks.UnknownSocksResponse;
import io.netty5.util.internal.StringUtil;

final class SocksCommonUtils {
    public static final SocksRequest UNKNOWN_SOCKS_REQUEST = new UnknownSocksRequest();
    public static final SocksResponse UNKNOWN_SOCKS_RESPONSE = new UnknownSocksResponse();
    private static final char ipv6hextetSeparator = ':';

    private SocksCommonUtils() {
    }

    public static String ipv6toStr(byte[] src) {
        assert (src.length == 16);
        StringBuilder sb = new StringBuilder(39);
        SocksCommonUtils.ipv6toStr(sb, src, 0, 8);
        return sb.toString();
    }

    private static void ipv6toStr(StringBuilder sb, byte[] src, int fromHextet, int toHextet) {
        int i;
        --toHextet;
        for (i = fromHextet; i < toHextet; ++i) {
            SocksCommonUtils.appendHextet(sb, src, i);
            sb.append(':');
        }
        SocksCommonUtils.appendHextet(sb, src, i);
    }

    private static void appendHextet(StringBuilder sb, byte[] src, int i) {
        StringUtil.toHexString((Appendable)sb, (byte[])src, (int)(i << 1), (int)2);
    }
}

