/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.utils;

import io.neow3j.constants.NeoConstants;
import io.neow3j.utils.Numeric;
import java.math.BigInteger;
import org.bouncycastle.math.ec.ECPoint;

public class KeyUtils {
    public static byte[] publicKeyIntegerToByteArray(BigInteger publicKey) {
        return Numeric.toBytesPadded(publicKey, 33);
    }

    public static byte[] privateKeyIntegerToByteArray(BigInteger privateKey) {
        return Numeric.toBytesPadded(privateKey, 32);
    }

    public static byte[] compressPublicKey(byte[] notCompressedPubKey) {
        ECPoint point = NeoConstants.curve().getCurve().decodePoint(notCompressedPubKey);
        return point.getEncoded(true);
    }

    public static boolean isPublicKeyCompressed(byte[] publicKey) {
        NeoConstants.curve().getCurve().decodePoint(publicKey);
        return publicKey[0] == 2 || publicKey[0] == 3;
    }
}

