/*
 * Decompiled with CFR 0.152.
 */
package io.mypojo.framework.revision;

import java.util.Enumeration;
import java.util.zip.ZipEntry;

class EntriesEnumeration
implements Enumeration {
    private final Enumeration m_enumeration;
    private final String m_prefix;
    private volatile Object current;

    public EntriesEnumeration(Enumeration enumeration) {
        this(enumeration, null);
    }

    public EntriesEnumeration(Enumeration enumeration, String prefix) {
        this.m_enumeration = enumeration;
        this.m_prefix = prefix;
    }

    @Override
    public boolean hasMoreElements() {
        while (this.current == null && this.m_enumeration.hasMoreElements()) {
            String result = ((ZipEntry)this.m_enumeration.nextElement()).getName();
            if (this.m_prefix != null) {
                if (!result.startsWith(this.m_prefix)) continue;
                this.current = result.substring(this.m_prefix.length());
                continue;
            }
            this.current = result;
        }
        return this.current != null;
    }

    public Object nextElement() {
        try {
            if (this.hasMoreElements()) {
                Object object = this.current;
                return object;
            }
            Object e = this.m_enumeration.nextElement();
            return e;
        }
        finally {
            this.current = null;
        }
    }
}

