/*
 * Decompiled with CFR 0.152.
 */
package io.mypojo.framework.revision;

import io.mypojo.framework.revision.FileEntriesEnumeration;
import io.mypojo.framework.revision.Revision;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirRevision
implements Revision {
    private static final Logger logger = LoggerFactory.getLogger(DirRevision.class);
    private final File m_file;

    public DirRevision(File file) {
        this.m_file = file;
    }

    @Override
    public long getLastModified() {
        return this.m_file.lastModified();
    }

    public Enumeration getEntries() {
        return new FileEntriesEnumeration(this.m_file);
    }

    @Override
    public URL getEntry(String entryName) {
        try {
            File file;
            if (entryName != null && (file = new File(this.m_file, entryName.startsWith("/") ? entryName.substring(1) : entryName)).exists()) {
                return file.toURL();
            }
        }
        catch (MalformedURLException e) {
            logger.error("Getting entry: " + entryName, (Throwable)e);
        }
        return null;
    }
}

