/*
 * Decompiled with CFR 0.152.
 */
package io.mypojo.framework.launch;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ManifestUtil {
    public static Map<String, String> getHeaders(URL manifestURL) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        byte[] bytes = new byte[1000000];
        try (InputStream input = manifestURL.openStream();){
            int size = 0;
            int i = input.read(bytes);
            while (i != -1) {
                if ((size += i) == bytes.length) {
                    byte[] tmp = new byte[size * 2];
                    System.arraycopy(bytes, 0, tmp, 0, bytes.length);
                    bytes = tmp;
                }
                i = input.read(bytes, size, bytes.length - size);
            }
            String key = null;
            int last = 0;
            int current = 0;
            for (int i2 = 0; i2 < size; ++i2) {
                if (bytes[i2] == 13 && i2 + 1 < size && bytes[i2 + 1] == 10) continue;
                if (bytes[i2] == 10 && i2 + 1 < size && bytes[i2 + 1] == 32) {
                    ++i2;
                    continue;
                }
                if (key == null && bytes[i2] == 58) {
                    key = new String(bytes, last, current - last, "UTF-8");
                    if (i2 + 1 < size && bytes[i2 + 1] == 32) {
                        last = current + 1;
                        continue;
                    }
                    throw new Exception("Manifest error: Missing space separator - " + key);
                }
                if (bytes[i2] == 10) {
                    if (last == current && key == null) {
                        break;
                    }
                    String value = new String(bytes, last, current - last, "UTF-8");
                    if (key == null) {
                        throw new Exception("Manifest error: Missing attribute name - " + value);
                    }
                    if (headers.put(key, value) != null) {
                        throw new Exception("Manifest error: Duplicate attribute name - " + key);
                    }
                    last = current;
                    key = null;
                    continue;
                }
                bytes[current++] = bytes[i2];
            }
        }
        return headers;
    }
}

