/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.resolve;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

final class Resolvers {
    private static final String PATH = "package/bin/esbuild";
    private static final String WINDOWS_EXE_PATH = "package/esbuild.exe";
    static final String CLASSIFIER = Resolvers.determineClassifier();

    private Resolvers() {
    }

    static String resolveBundledExecutablePath() {
        return Resolvers.isWindows() ? "package/bin/esbuild.exe" : PATH;
    }

    static String resolveExecutablePath() {
        return Resolvers.isWindows() ? WINDOWS_EXE_PATH : PATH;
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.contains("win");
    }

    private static String determineClassifier() {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        String classifier = osName.contains("mac") ? (osArch.equals("aarch64") || osArch.contains("arm") ? "darwin-arm64" : "darwin-x64") : (osName.contains("win") ? (osArch.contains("64") ? "win32-x64" : "win32-ia32") : (osArch.equals("aarch64") || osArch.equals("arm64") ? "linux-arm64" : (osArch.contains("arm") ? "linux-arm" : (osArch.contains("64") ? "linux-x64" : "linux-ia32"))));
        return classifier;
    }

    static Path extract(InputStream archive, String destination) throws IOException {
        File destinationFile = Resolvers.createDestination(destination).toFile();
        return Resolvers.extract(archive, destinationFile);
    }

    static Path extract(InputStream archive, File destination) throws IOException {
        if (!destination.exists()) {
            destination.mkdirs();
        }
        try (GzipCompressorInputStream gzipIn = new GzipCompressorInputStream(archive);
             TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzipIn);){
            ArchiveEntry entry;
            while ((entry = tarIn.getNextEntry()) != null) {
                if (!tarIn.canReadEntryData(entry) || entry.isDirectory()) continue;
                File outputFile = new File(destination, entry.getName());
                File parentDir = outputFile.getParentFile();
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                if (Files.exists(outputFile.toPath(), new LinkOption[0])) {
                    Files.delete(outputFile.toPath());
                }
                Files.createFile(outputFile.toPath(), new FileAttribute[0]);
                int mode = ((TarArchiveEntry)entry).getMode();
                Set<PosixFilePermission> permissions = Resolvers.convertModeToPosixFilePermissions(mode);
                try {
                    Files.setPosixFilePermissions(outputFile.toPath(), permissions);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = tarIn.read(buffer)) != -1) {
                        ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                    }
                }
            }
        }
        return destination.toPath();
    }

    static Path createDestination(String version) throws IOException {
        return Files.createDirectories(Resolvers.getLocation(version), new FileAttribute[0]);
    }

    static Path getLocation(String version) {
        return Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve("esbuild-" + version);
    }

    private static Set<PosixFilePermission> convertModeToPosixFilePermissions(int mode) {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.values()));
        for (int i = 0; i < 9; ++i) {
            int mask = 1 << 8 - i;
            if ((mode & mask) != 0) continue;
            permissions.remove((Object)Resolvers.getPermissionForIndex(i));
        }
        return permissions;
    }

    private static PosixFilePermission getPermissionForIndex(int index) {
        switch (index) {
            case 0: {
                return PosixFilePermission.OWNER_READ;
            }
            case 1: {
                return PosixFilePermission.OWNER_WRITE;
            }
            case 2: {
                return PosixFilePermission.OWNER_EXECUTE;
            }
            case 3: {
                return PosixFilePermission.GROUP_READ;
            }
            case 4: {
                return PosixFilePermission.GROUP_WRITE;
            }
            case 5: {
                return PosixFilePermission.GROUP_EXECUTE;
            }
            case 6: {
                return PosixFilePermission.OTHERS_READ;
            }
            case 7: {
                return PosixFilePermission.OTHERS_WRITE;
            }
            case 8: {
                return PosixFilePermission.OTHERS_EXECUTE;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + index);
    }
}

