/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mvnpm.esbuild.install.MvnpmInfo;
import io.mvnpm.esbuild.install.WebDepsInstaller;
import io.mvnpm.esbuild.model.AutoEntryPoint;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DependenciesAutoImports {
    private static final String[] FIELDS = new String[]{"name", "module", "main", "style", "sass", "browser"};
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String IMPORT = "import \"%s\";";

    static String dependenciesImports(Path nodeModulesDir, Predicate<String> idsPredicate, boolean onlyStyles) {
        MvnpmInfo mvnpmInfo = WebDepsInstaller.readMvnpmInfo(WebDepsInstaller.getMvnpmInfoPath(nodeModulesDir));
        Stream<Path> packageJsons = mvnpmInfo.installed().stream().filter(d -> idsPredicate.test(d.id())).flatMap(dependency -> dependency.dirs().stream().map(d -> nodeModulesDir.resolve((String)d).resolve("package.json"))).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
        String entries = packageJsons.map(packageJson -> {
            StringBuilder imports = new StringBuilder();
            Map<String, String> data = DependenciesAutoImports.readPackage(packageJson);
            if (!data.getOrDefault("sass", "").isBlank()) {
                imports.append(IMPORT.formatted(data.get("name") + "/" + data.get("sass"))).append("\n");
            } else if (!data.getOrDefault("style", "").isBlank()) {
                imports.append(IMPORT.formatted(data.get("name") + "/" + data.get("style"))).append("\n");
            }
            if (onlyStyles) {
                return imports.toString();
            }
            if (AutoEntryPoint.isScript(data.get("module")) && !data.getOrDefault("browser", "").isBlank()) {
                imports.append(IMPORT.formatted(data.get("name"))).append("\n");
            } else if (AutoEntryPoint.isScript(data.get("main"))) {
                imports.append(IMPORT.formatted(data.get("name"))).append("\n");
            }
            return imports.toString();
        }).filter(Predicate.not(String::isBlank)).collect(Collectors.joining(""));
        return "// Auto-generated imports for web dependencies\n" + entries + "\n";
    }

    private static Map<String, String> readPackage(Path path) {
        HashMap<String, String> contents = new HashMap<String, String>(FIELDS.length);
        try {
            JsonNode object = objectMapper.readTree(path.toFile());
            for (String field : FIELDS) {
                if (!object.has(field)) continue;
                JsonNode node = object.get(field);
                contents.put(field, node.isValueNode() ? node.asText() : "[object]");
            }
            return contents;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

