/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.model;

import io.mvnpm.esbuild.model.DependenciesAutoImports;
import io.mvnpm.esbuild.model.EntryPoint;
import io.mvnpm.esbuild.util.PathUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public record AutoEntryPoint(Path rootDir, String name, List<Source> sources, AutoDeps autoDeps) implements EntryPoint
{
    private static final Set<String> SCRIPTS = Set.of("js", "ts", "jsx", "tsx", "mjs", "mts", "cjs", "cts");
    private static final String EXPORT = "export * from \"./%s\";";
    private static final String IMPORT = "import \"./%s\";";

    public AutoEntryPoint {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(rootDir, "rootDir is required");
        Objects.requireNonNull(sources, "sources are required");
    }

    public static EntryPoint withoutAutoDeps(Path rootDir, String name, List<String> sources) {
        return AutoEntryPoint.withAutoDeps(rootDir, name, sources, null);
    }

    public static EntryPoint withAutoDeps(Path rootDir, String name, List<String> sources, AutoDeps autoDeps) {
        List<Source> sourceList = Objects.requireNonNull(sources, "sources are required").stream().map(Source::of).toList();
        return new AutoEntryPoint(rootDir, name, sourceList, autoDeps);
    }

    @Override
    public Path process(Path workDir) {
        try {
            AutoDepsMode resolvedMode;
            Object content = "";
            AutoDepsMode autoDepsMode = resolvedMode = this.autoDeps != null ? this.autoDeps.mode() : AutoDepsMode.NONE;
            if (resolvedMode == AutoDepsMode.AUTO) {
                resolvedMode = this.sources.stream().noneMatch(Source::isScript) ? AutoDepsMode.ALL : AutoDepsMode.STYLES;
            }
            switch (resolvedMode) {
                case ALL: {
                    content = (String)content + DependenciesAutoImports.dependenciesImports(this.autoDeps.nodeModulesDir, this.autoDeps.idsPredicate, false);
                    break;
                }
                case STYLES: {
                    content = (String)content + DependenciesAutoImports.dependenciesImports(this.autoDeps.nodeModulesDir, this.autoDeps.idsPredicate, true);
                    break;
                }
            }
            content = (String)content + this.autoImportsSources(workDir);
            return AutoEntryPoint.createEntryPoint(this.name, workDir, (String)content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Path createEntryPoint(String name, Path workDir, String content) throws IOException {
        Path entry = workDir.resolve("%s.js".formatted(name));
        Files.writeString(entry, (CharSequence)content, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        return entry;
    }

    private String autoImportsSources(Path workDir) {
        String string;
        if (this.sources.isEmpty()) {
            return "";
        }
        if (!Objects.equals(this.rootDir, workDir)) {
            PathUtils.copyEntries(this.rootDir, this.sources.stream().map(Source::relativePath).toList(), workDir);
        }
        StringWriter sw = new StringWriter();
        try {
            sw.write("// Auto-generated imports for project sources\n");
            for (Source source : this.sources) {
                String line = source.isScript() ? EXPORT.formatted(source.relativePathWithoutExt()) : IMPORT.formatted(source.relativePath());
                sw.write(line);
                sw.write("\n");
            }
            sw.write("\n");
            string = sw.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    sw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        sw.close();
        return string;
    }

    public static boolean isScript(String relativePath) {
        if (relativePath == null || relativePath.isBlank()) {
            return false;
        }
        String ext = AutoEntryPoint.resolveExtension(relativePath);
        return SCRIPTS.contains(ext);
    }

    public static String resolveExtension(String relativePath) {
        String fileName = Path.of(relativePath, new String[0]).getFileName().toString();
        int index = fileName.lastIndexOf(".");
        return fileName.substring(index + 1);
    }

    public record AutoDeps(AutoDepsMode mode, Path nodeModulesDir, Predicate<String> idsPredicate) {
        public AutoDeps(AutoDepsMode mode, Path nodeModulesDir) {
            this(mode, nodeModulesDir, id -> true);
        }
    }

    public static enum AutoDepsMode {
        ALL,
        STYLES,
        AUTO,
        NONE;

    }

    record Source(String relativePath, String ext) {
        public static Source of(String relativePath) {
            String ext = AutoEntryPoint.resolveExtension(relativePath);
            return new Source(relativePath, ext);
        }

        public String relativePathWithoutExt() {
            return this.relativePath.substring(0, this.relativePath.lastIndexOf("."));
        }

        public boolean isScript() {
            return SCRIPTS.contains(this.ext);
        }
    }
}

