/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild;

import io.mvnpm.esbuild.Bundler;
import io.mvnpm.esbuild.Execute;
import io.mvnpm.esbuild.model.ExecuteResult;
import io.mvnpm.esbuild.resolve.Resolver;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;

public class Main {
    public static void main(String[] args) throws IOException {
        String workingDirectory = System.getProperty("user.dir");
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        Optional<String> esbuildVersionArgument = arguments.stream().filter(a -> a.startsWith("--esbuildVersion")).findFirst();
        String esbuildVersion = Bundler.ESBUILD_EMBEDDED_VERSION;
        if (esbuildVersionArgument.isPresent()) {
            arguments.remove(esbuildVersionArgument.get());
            String unParsedEsbuildVersion = esbuildVersionArgument.get();
            esbuildVersion = unParsedEsbuildVersion.split("=")[1];
        }
        Path esBuildExec = Resolver.create().resolve(esbuildVersion);
        ExecuteResult executeResult = new Execute(Paths.get(workingDirectory, new String[0]), esBuildExec.toFile(), arguments.toArray(new String[0])).executeAndWait();
        System.out.println(executeResult.output());
    }
}

